;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ****h* sc/clm-akoustik-piano-spectra.lsp
;;; NAME
;;; globals
;;;
;;; File:             clm-piano-spectra.lsp
;;;
;;; Class Hierarchy:  None: no classes defined.
;;;
;;; Version:          1.0.8
;;;
;;; Project:          slippery chicken (algorithmic composition)
;;;
;;; Purpose:          For reading in from spectra.lsp: From Akoustic Piano's 
;;;                   samples library: "/Akoustik Piano
;;;                   Library/Samples/ConcertGrand/Samples/". We can use this
;;;                   data for the calculation of chord dissonance values in
;;;                   the chord class's calculate-dissonance method.
;;; 
;;; Author:           Michael Edwards: m@michael-edwards.org
;;;
;;; Creation date:    5th August 2015
;;;
;;; $$ Last modified: 12:30:03 Tue Feb  2 2016 GMT
;;;
;;; SVN ID: $Id: clm-piano-spectra.lsp 963 2010-04-08 20:58:32Z medward2 $
;;;
;;; ****
;;; Licence:          Copyright (c) 2010 Michael Edwards
;;;
;;;                   This file is part of slippery-chicken
;;;
;;;                   slippery-chicken is free software; you can redistribute it
;;;                   and/or modify it under the terms of the GNU General
;;;                   Public License as published by the Free Software
;;;                   Foundation; either version 2 of the License, or (at your
;;;                   option) any later version.
;;;
;;;                   slippery-chicken is distributed in the hope that it will
;;;                   be useful, but WITHOUT ANY WARRANTY; without even the
;;;                   implied warranty of MERCHANTABILITY or FITNESS FOR A
;;;                   PARTICULAR PURPOSE.  See the GNU General Public License
;;;                   for more details.
;;;
;;;                   You should have received a copy of the GNU General Public
;;;                   License along with slippery-chicken; if not, write to the
;;;                   Free Software Foundation, Inc., 59 Temple Place, Suite
;;;                   330, Boston, MA 02111-1307 USA
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; don't put any package specification here as this file is only meant for
;;; reading in via (read)

(MAKE-ASSOC-LIST
 'AKOUSTIK-PIANO-SPECTRA
 '((21 
    ((0.0 2.0711345642522287d0 2.9406743544179923d0 3.9432563710307327d0
          4.988863189071091d0 0.0 6.985676163710781d0 0.0 9.019547618122614d0
          9.982987494233676d0 10.985379359678461d0 12.034185714273953d0)
     (0.0d0 0.06903657593345974d0 0.20276219505527213d0 1.0d0
            0.5720771562459225d0 0.0d0 0.15812188646377978d0 0.0d0
            0.08608246076123945d0 0.05785283256827822d0 0.26147182549588327d0
            0.19178314988426903d0)) )
   (23 
    ((1.0940507316113082d0 0.0 3.083949705490623d0 3.89407973008319d0
                           4.893969478743521d0 5.88893812511525d0 6.952027720381207d0
                           8.050503356869523d0 0.0 10.063443872797556d0 10.887002651865188d0
                           12.019215491776087d0)
     (0.08240904067058266d0 0.0d0 0.7950595352995515d0 1.0d0
                            0.399228076907347d0 0.6554102569218195d0 0.08290653879444912d0
                            0.08157717702873751d0 0.0d0 0.15630627857447366d0 0.19066718001506466d0
                            0.6486223463831698d0)) )
   (24 
    ((0.9941203024657121d0 1.9624760970228483d0 2.9784004025120434d0
                           3.9624122462265094d0 4.942077962136486d0 5.946691882018734d0
                           6.896563848408831d0 7.976768994951194d0 8.978483247230155d0
                           9.872615805594807d0 11.02567797030669d0 12.056748801999621d0)
     (0.005295217062800103d0 0.30666893255637084d0 1.0d0 0.8361434795989307d0
                             0.20986989858561783d0 0.4637883536845606d0 0.1882508515071722d0 0.0d0
                             0.054419524406317255d0 0.08030516653191024d0 0.1778930070050988d0
                             0.2523359459867342d0)) )
   (26 
    ((0.951024237000931d0 2.046068219252724d0 2.955717027303568d0
                          4.086610746652896d0 4.984235053942286d0 5.967804664238343d0
                          7.024529244506904d0 0.0 9.082853725297584d0 9.984147960912784d0
                          11.065796562247986d0 12.038813513843841d0)
     (0.03879506891980158d0 0.3429046342741457d0 1.0d0 0.2647596120938387d0
                            0.46546731383677126d0 0.12494007278180252d0 0.3338334425568532d0 0.0d0
                            0.017871304330194796d0 0.28728167584652936d0 0.07829030980673277d0
                            0.2000052003309094d0)) )
   (28 
    ((0.0 2.0424077332956627d0 2.9890126541853914d0 3.9436388360724792d0
          4.972546896260217d0 6.0021297975115075d0 7.053390984171799d0
          7.998801429233497d0 9.040130489095512d0 9.972168958664207d0
          11.014719734640083d0 12.023544441213035d0)
     (0.0d0 0.8197794775855692d0 1.0d0 0.4890514104437867d0
            0.9134331040697843d0 0.6499870721172057d0 0.40613474316165665d0
            0.07933024351915574d0 0.3391647603405937d0 0.43152610335341746d0
            0.3314622112204652d0 0.36037357696478356d0)) )
   (29 
    ((0.0 1.9870434073902234d0 2.977456156034386d0 3.9683974239200066d0
          4.9617511431459d0 5.9834329241081425d0 6.970885232662641d0
          8.089475613601072d0 9.097743336631783d0 10.083081340455808d0
          11.084658768669238d0 12.084245846829186d0)
     (0.0d0 0.8702851998977778d0 0.9464265952939716d0 1.0d0
            0.3296966521921474d0 0.49416863200336675d0 0.16286353423119804d0
            0.04620105374143128d0 0.07631138750585208d0 0.13919911668211957d0
            0.16558510942579066d0 0.09029027135343953d0)) )
   (31 
    ((0.8553278377296266d0 1.9828741796138631d0 3.099548570093457d0
                           3.9551947007204404d0 5.06394624050625d0 5.984439593494791d0
                           7.02425899863363d0 8.146986594033654d0 9.008342235914212d0
                           10.06344699378049d0 11.046188299950456d0 12.05801266840112d0)
     (0.0d0 1.0d0 0.2505502665428825d0 0.5528109309105151d0
            0.2813848602966371d0 0.3171129647529309d0 0.24269738867209276d0
            6.823346032593935d-4 0.028596020142149375d0 0.13544484920645544d0
            0.12495059573810818d0 0.1718576949471368d0)) )
   (33 
    ((0.9807924273962622d0 1.9731896527348665d0 2.9793287347687234d0
                           3.9390609524433997d0 5.047629993413228d0 6.052638190643145d0
                           7.017736752736327d0 7.993484567886696d0 8.999632235556263d0
                           10.02025590951863d0 11.04097143604789d0 12.086612183310647d0)
     (0.07758140908828492d0 1.0d0 0.3124880833342018d0 0.1025662988182416d0
                            0.3076684641858587d0 0.34153526647538757d0 0.05513739499487735d0 0.0d0
                            0.058457141614956507d0 0.17277539243197673d0 0.17776541484734643d0
                            0.1283192258195256d0)) )
   (35 
    ((1.0421015134684162d0 2.001952494216811d0 2.996590535998905d0
                           3.9976610018227814d0 5.0368183873119206d0 6.031084425503747d0
                           6.955852528908988d0 8.008674725403909d0 9.065957032470482d0
                           10.079722912557122d0 11.067795984679995d0 12.01030035437235d0)
     (0.412886472542994d0 0.7197185484431434d0 1.0d0 0.1592843405513546d0
                          0.63941563446994d0 0.29521423045146106d0 0.022301410154885126d0
                          0.05558240247554386d0 0.2249491984684861d0 0.3462652886037754d0
                          0.08514060699426014d0 0.0d0)) )
   (36 
    ((0.9923722106532037d0 1.984381907617616d0 2.9797619222354315d0
                           4.002305317942899d0 5.036879145327949d0 6.073978323486318d0
                           7.071066177149901d0 8.063858528083722d0 9.054698695102685d0
                           10.036795629003128d0 11.05326579399118d0 0.0)
     (0.9819612320650914d0 1.0d0 0.31957731653818683d0 0.2782685444543481d0
                           0.37280817681168915d0 0.08763271383389808d0 0.2981675745387186d0
                           0.18309722068130438d0 0.11719981194642988d0 0.24211808452839384d0
                           0.0834758614455897d0 0.0d0)) )
   (38 
    ((1.017334005563817d0 2.0268747024918436d0 3.01827715269107d0
                          3.9969166670027305d0 5.006719558755829d0 6.02400764434256d0
                          7.048100174741404d0 8.070414141888874d0 9.072163057216258d0
                          10.099334391166673d0 11.07830381150209d0 12.101002702113133d0)
     (0.9733218957657571d0 1.0d0 0.46060593152102186d0 0.18970598820439244d0
                           0.14211604847733478d0 0.16554867367585394d0 0.31921319446987545d0
                           0.035851133507755574d0 0.0d0 0.03296487488465074d0
                           0.026809795173429747d0 0.019175400847274447d0)) )
   (40 
    ((1.0280206910049596d0 1.9949655970232876d0 3.0088383033730346d0
                           4.043339334600252d0 5.066029546394264d0 6.0255656122629615d0
                           7.052582681000193d0 8.114496128837246d0 9.072330501012711d0
                           10.084949169452772d0 11.103643175877913d0 12.046037087110909d0)
     (0.9179630373023412d0 0.9829031704079928d0 0.9999999999999999d0
                           0.6819302248325076d0 0.17951077860958947d0 0.2828304782620496d0
                           0.19237471335643708d0 0.08551369301000913d0 0.03720127101605326d0
                           0.1988775038473195d0 0.08084974539047302d0 0.0d0)) )
   (41 
    ((0.994785530442185d0 1.9880974191295646d0 2.993044822960739d0
                          3.9660376658535115d0 5.049418534718431d0 6.035817377691022d0
                          7.0678061500165255d0 7.992117629257727d0 9.003874488883014d0
                          10.062082045635709d0 11.110122943746553d0 12.082764621781065d0)
     (0.6565136098166361d0 1.0d0 0.5444779675381409d0 0.08360941252266749d0
                           0.19727348637362033d0 0.24341100121440068d0 0.009136610183831322d0 0.0d0
                           0.04088311051057548d0 0.10133784183454075d0 0.007295122737360937d0
                           0.011953571356347798d0)) )
   (43 
    ((0.9930596409244462d0 1.9887234667707123d0 3.001178386542311d0
                           4.0254006794121215d0 5.050280758744143d0 6.043238446275825d0
                           7.03078605199979d0 8.020450354299511d0 9.05582523151376d0
                           10.083759022906937d0 11.095948482479512d0 12.119105826250527d0)
     (0.8650705257698552d0 1.0d0 0.2324837069591881d0 0.33771021615942826d0
                           0.053002473759942305d0 0.17108300259969822d0 0.2402011007111393d0
                           0.0046115228172761945d0 0.028822320492623406d0 0.01047683670342357d0
                           0.08017461236859658d0 0.0d0)) )
   (45 
    ((0.9919869183731335d0 1.9529837299444461d0 3.0277331799302036d0
                           4.019321562608279d0 5.036822191927045d0 6.059780620297709d0
                           7.038462730716245d0 8.064989257027367d0 9.083181927065857d0
                           10.08806543903808d0 11.138280970701972d0 12.138278366481927d0)
     (1.0d0 0.05115851896485519d0 0.7903108250111263d0 0.43815283853325004d0
            0.10581678783272286d0 0.45238688767508667d0 0.15854946601909664d0
            0.03829682342292396d0 0.030771229988439057d0 0.08540412661386124d0
            0.03901424185042739d0 0.0d0)) )
   (47 
    ((1.0072268833787712d0 2.006488894400395d0 3.0224365668759554d0
                           4.0084502922983d0 5.0438232384655945d0 6.0212358341638135d0
                           7.049927260940666d0 8.033283097349559d0 9.071931549925294d0
                           10.079762802497791d0 11.103732363452133d0 12.121157889153908d0)
     (0.502524037007728d0 1.0d0 0.3569562417136152d0 0.06204894615720788d0
                          0.17181233800120824d0 0.2612694743149075d0 0.04865226881874751d0 0.0d0
                          0.011252100838234056d0 0.014452952058326803d0 0.006591275192429323d0
                          0.014691774722009016d0)) )
   (48 
    ((0.9935483634642207d0 1.994867864018912d0 2.9951333556829542d0
                           4.02760545756282d0 5.017790985960185d0 6.019471802872981d0
                           7.058119722616564d0 8.062465061957374d0 9.062068202859116d0
                           10.10178842088344d0 11.114362783767886d0 12.114929812962032d0)
     (0.9572359947251174d0 1.0d0 0.12085934152600336d0 0.43898834577444423d0
                           0.5608677955634336d0 0.2556689331504939d0 0.052737388226467466d0
                           0.00819387711105361d0 0.00715066900783197d0 0.0d0 0.037715039130176015d0
                           4.891211165761605d-4)) )
   (50 
    ((1.0129760261465626d0 2.0007637639203932d0 3.0023809451195036d0
                           4.030343848439467d0 5.034159731566996d0 6.0240298976951046d0
                           7.038258521145217d0 8.062605729317916d0 9.098572159242396d0
                           10.112120230683638d0 11.133729866945396d0 0.0)
     (1.0d0 0.5571960594119886d0 0.30522657859101177d0 0.6476690969414072d0
            0.3337509379578473d0 0.20736232440288424d0 0.2011221139426381d0
            0.12953350403966465d0 0.07119162815959014d0 0.18691705829052208d0
            0.03110602391459651d0 0.0d0)) )
   (52 
    ((0.9936119024149889d0 2.019172641582346d0 3.0063747377967593d0
                           4.021781917122785d0 5.032042656000189d0 6.033216568495658d0
                           7.054322955574638d0 8.05532696238239d0 9.081731705036185d0
                           10.124095014492008d0 11.13762806093686d0 12.13151117817794d0)
     (0.6034730337608557d0 1.0d0 0.9128081275450787d0 0.2999760987955063d0
                           0.14417602478984842d0 0.20123133268156881d0 0.014834967874640993d0
                           0.017159055705070096d0 0.0627518627092475d0 0.03516999134042173d0
                           0.007233134926402596d0 0.0d0)) )
   (53 
    ((0.9929983830628716d0 2.0194518077168486d0 3.0223271093986503d0
                           4.0151614231254555d0 5.040362783694049d0 6.044573669741389d0
                           7.060825070428483d0 8.072180038770403d0 9.087926419253224d0
                           10.119064179316686d0 11.023767540669745d0 12.012915071674113d0)
     (1.0d0 0.4251739516508417d0 0.1677188206313603d0 0.07052527930887811d0
            0.1724798389926553d0 0.07482296200065d0 0.018971010182907772d0
            0.038270767670461434d0 0.0064578252041410725d0 0.003181934186101886d0
            2.851773138620199d-4 0.0d0)) )
   (55 
    ((0.994210422397459d0 2.0132019695338896d0 3.0210558333317663d0
                          4.015687311876854d0 5.039882044756555d0 6.039546357242998d0
                          7.07158530032154d0 8.066475488491532d0 9.11724093269905d0 0.0 0.0 0.0)
     (1.0d0 0.30090596978098366d0 0.14949020297105417d0 0.2991891065854226d0
            0.25783644975071035d0 0.132037011897897d0 0.13485379199073347d0
            0.006373867656602468d0 0.022457930177259288d0 0.0d0 0.0d0 0.0d0)) )
   (57 
    ((1.0103484912366156d0 2.0081838579178295d0 3.030214961208891d0
                           4.023074227197667d0 5.0416888186441895d0 6.064804763647608d0
                           7.095692958484619d0 8.056746638270964d0 9.000786138908285d0 0.0
                           11.117530646321034d0 0.0)
     (0.24754575980024254d0 1.0d0 0.20129491455946127d0 0.11327307804231394d0
                            0.036283253264988755d0 0.04074423526218555d0 0.03037616277394974d0
                            0.004030915843150511d0 7.553359494427242d-4 0.0d0 0.001439258474435741d0
                            0.0d0)) )
   (59 
    ((1.0028947472095335d0 2.0061486644095634d0 3.0087932932874146d0
                           4.014324997119126d0 5.026129435265955d0 6.056306127522819d0
                           7.06781640545113d0 8.107194436794714d0 9.055172177180438d0
                           10.092721301005426d0 11.021084038038287d0 12.070078428299865d0)
     (1.0d0 0.43252200579423705d0 0.16981691316348166d0 0.14856783832956824d0
            0.1202489260026823d0 0.14575393895197414d0 0.13164892580926837d0
            0.015590294582787803d0 6.235990839184204d-4 0.001125290570681706d0
            3.4231269067704583d-4 0.0d0)) )
   (60 
    ((0.9982489206168257d0 2.014263461548936d0 3.0090767036403947d0
                           4.025891753079929d0 5.0391785223504755d0 6.051163469385689d0
                           7.078870767769303d0 8.11774500511693d0 9.141433982196514d0
                           10.04537485275207d0 11.106391686695847d0 12.001576621760098d0)
     (1.0d0 0.9109448701195313d0 0.1297772712530461d0 0.023180974425249693d0
            0.10626249187411438d0 0.032987868123220285d0 0.06347792594614733d0
            0.007317840181906495d0 0.013016407762932449d0 0.0010244973556402305d0
            0.0d0 0.0012012708361875803d0)) )
   (62 
    ((1.001238573965469d0 2.0147455500765044d0 3.015557241344336d0
                          4.035054863133926d0 5.056127381396649d0 6.083410440384472d0
                          7.101901435764062d0 8.139212653950905d0 9.077534250737212d0 0.0
                          11.061675385210705d0 11.953337537982643d0)
     (1.0d0 0.35333552437446647d0 0.08102691789642334d0 0.2606116652722964d0
            0.27892341706553064d0 0.06476651905686805d0 0.028474106348059008d0
            0.06667309087311131d0 0.0035557282837508555d0 0.0d0
            0.0024282457945842524d0 0.0024706032762346923d0)) )
   (64 
    ((1.0093106860354546d0 2.0113883472952554d0 3.01057728707131d0
                           4.026850554418135d0 5.038552118262078d0 6.070409450868894d0
                           7.10182116979671d0 8.040800542519827d0 9.038872513490805d0
                           10.043891979812855d0 11.061514337542802d0 12.05524210252868d0)
     (1.0000000000000002d0 0.43981468819618125d0 0.13365942532793026d0
                           0.02380996181595924d0 0.03976894812209942d0 0.007506330520028701d0
                           0.015610118347022752d0 0.0010411956414288137d0 0.0014756800410858544d0
                           3.3324339762870144d-4 1.7306796872927784d-4 0.0d0)) )
   (65 
    ((1.0107098209667444d0 2.0068750236137185d0 3.019647430063235d0
                           4.040803439233032d0 5.055812913673791d0 6.080406119649338d0
                           7.122777450635666d0 8.059233292823585d0 9.089691733630765d0
                           10.055776538357108d0 10.965596701938757d0 12.030632769090715d0)
     (0.9999999999999999d0 0.44641519009822545d0 0.14275480125142068d0
                           0.12756300080658992d0 0.09605321431756302d0 0.06800206843881523d0
                           0.06139849747840622d0 5.913057082638916d-4 4.516803129820633d-4
                           2.8022908453296364d-4 2.3575360766064338d-4 0.0d0)) )
   (67 
    ((1.0103674269106484d0 2.00608653872613d0 3.021431134657277d0
                           4.038792557457237d0 5.068349974941977d0 6.055773257935665d0
                           7.061363208649456d0 7.8549251182566735d0 9.016735299035817d0
                           10.079990171521056d0 11.04757877000227d0 11.968805971603004d0)
     (1.0000000000000002d0 0.12097648887170769d0 0.28732128220501896d0
                           0.0458869026189402d0 0.00943989549931005d0 0.015279279761047471d0
                           0.007395757284802497d0 0.0014061850353536466d0 3.6477734145253394d-4
                           2.257151506151636d-4 1.1238326271006483d-4 0.0d0)) )
   (69 
    ((1.0041285558876951d0 2.0119952222867936d0 3.0306193709053866d0
                           4.041877724525061d0 5.075558810256299d0 6.052114717163081d0
                           6.948082500474647d0 8.042887426325917d0 9.035932389609833d0
                           10.008496210046621d0 11.00339399989952d0 11.9965552852643d0)
     (0.9999999999999999d0 0.1942585575088211d0 0.10693374473471702d0
                           0.093821943439739d0 0.03652602777179557d0 0.0012871372920925392d0
                           6.246387150168265d-4 3.2137953438887636d-4 2.03523588088179d-5
                           1.1928623938294546d-4 5.103035185110899d-5 0.0d0)) )
   (71 
    ((1.0035413228886303d0 2.0097551624838705d0 3.029666040272755d0
                           4.055013811681049d0 5.081765893116837d0 6.130654786355485d0
                           6.874976108929609d0 8.021132453874866d0 9.014652209979213d0
                           10.032016345220544d0 11.015050993109256d0 12.031998814030596d0)
     (1.0d0 0.20789277687178825d0 0.27163846305673833d0 0.14371798835790198d0
            0.07419031375597082d0 0.17022243438640133d0 0.001621013169872668d0
            6.87751037115075d-4 2.279526134006333d-4 1.105158375187773d-4
            4.636024834924163d-5 0.0d0)) )
   (72 
    ((1.0077545288123213d0 2.015684001765782d0 3.028795913402981d0
                           4.0541166000210085d0 5.08481145734531d0 6.107226352079028d0
                           7.049265342709564d0 8.027816036626298d0 9.047799383799159d0
                           10.042446853336724d0 11.025306719975015d0 12.045121423097111d0)
     (1.0d0 0.14656487184583886d0 0.04391976593401908d0 0.05500612896593315d0
            0.02850586555780647d0 0.0039446825729920615d0 2.678062269049201d-4
            4.2880452389740085d-5 9.20486325212254d-5 6.167981250751548d-5
            3.5720067377556785d-5 0.0d0)) )
   (74 
    ((1.007988631862142d0 2.016643523706763d0 3.030956721461387d0
                          4.065270519263744d0 5.107377804984421d0 6.120107187974156d0
                          7.013752690871896d0 8.032477960181069d0 9.025014103936712d0
                          9.997350474300427d0 10.949967297231263d0 0.0)
     (1.0d0 0.0756674920134841d0 0.00774288698502026d0 0.030356416798996717d0
            0.011411821493800794d0 3.732013225641387d-4 3.5753496092237857d-4
            3.0655417878553776d-4 2.6762479641850357d-4 2.410280011586127d-4
            2.5265911892679996d-4 0.0d0)) )
   (76 
    ((1.0096803653841844d0 2.0159239644261593d0 3.035995827796937d0
                           4.069732228671795d0 5.12592242453256d0 6.028506309748134d0
                           7.038178412548118d0 8.064668534436755d0 9.012024256372328d0
                           9.96868439691607d0 11.021177087571841d0 0.0)
     (1.0d0 0.19317859964633222d0 0.06295362912090402d0 0.03576932297527697d0
            0.01218534148555258d0 0.0018316970416085883d0 0.0014996270382168053d0
            0.001305228018322914d0 0.0014502278205639077d0 0.001310400428234867d0
            0.0014474836392560754d0 0.0d0)) )
   (77 
    ((1.0045989251496732d0 2.0187900795133693d0 3.0385524100367274d0
                           4.073843673175793d0 5.0964883346510685d0 5.982822643585094d0
                           7.038182937321584d0 8.014050841830821d0 9.007918850904318d0 0.0 0.0 0.0)
     (1.0d0 0.21554736754636075d0 0.1484521348499037d0 0.04652509477857292d0
            0.002326078548796157d0 0.001019687115817458d0 8.940163511115249d-4
            7.7460843787597d-4 9.61937739778498d-4 0.0d0 0.0d0 0.0d0)) )
   (79 
    ((1.004588846079758d0 2.0188954555808425d0 3.0457964128463524d0
                          4.08311080234874d0 5.042878984211835d0 6.016415857765595d0
                          6.915381840746538d0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.1879355084753558d0 0.04724299309237664d0 0.007026856464883426d0
            7.973203496650697d-4 6.185590871901028d-4 5.20394722560943d-4 0.0d0
            0.0d0 0.0d0 0.0d0 0.0d0)) )
   (81 
    ((1.0055854733874692d0 2.0190787605765643d0 3.0365398030860766d0
                           4.071327909534851d0 4.998820117405864d0 5.980355333783787d0
                           6.940053031449751d0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.15487644204634357d0 0.06043743520298417d0 0.05604653484800995d0
            0.001085229318626416d0 9.638351925734745d-4 2.4399654760695543d-4 0.0d0
            0.0d0 0.0d0 0.0d0 0.0d0)) )
   (83 
    ((1.0070335991818167d0 2.0245284089693785d0 3.0527936748462245d0
                           4.093895495553774d0 4.989741474848309d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.552995334389942d0 0.2980809320711342d0 0.0283499062482926d0
            0.0022286318774173007d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (84 
    ((1.0070476572485603d0 2.0255610887457465d0 3.055381590700589d0
                           4.05376917968636d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.3880903858468448d0 0.14750264094452673d0 0.029087314865863276d0
            0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (86 
    ((1.0089103848396315d0 2.0282889861384645d0 3.0680849090771125d0
                           4.018371146253781d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.22057048278232347d0 0.018558698592665516d0 6.870096575027823d-4
            0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (88 
    ((1.0055970086955996d0 2.014426926886691d0 3.005814699428225d0
                           3.941843014844854d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.050998910708947014d0 0.0016948980913714905d0
            0.0010765139969678714d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (89 
    ((1.0112466697425966d0 2.0306718198193363d0 3.0460027237265965d0 0.0 0.0
                           0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.044434043427843184d0 0.0010510197453662302d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (91 
    ((1.0093321325453954d0 2.015061061394972d0 3.0280062069052427d0 0.0 0.0
                           0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.01945672718417581d0 0.0010365407686369348d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (93 
    ((1.0106438128160187d0 2.019823563498926d0 3.1203243422821596d0 0.0 0.0
                           0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.0069513349617835495d0 0.012193304880612354d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (95 
    ((1.0132571877733383d0 2.014166302906951d0 3.146486197773883d0 0.0 0.0 0.0
                           0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.015124303862956183d0 0.0037712404938687522d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (96 
    ((1.0143515845499909d0 2.02631793606312d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
                           0.0 0.0)
     (1.0d0 0.007394443003673535d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0)) )
   (98 
    ((1.0151539223908734d0 2.0331637002256238d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
                           0.0 0.0 0.0)
     (0.9999999999999999d0 0.009648988654561036d0 0.0d0 0.0d0 0.0d0 0.0d0
                           0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (100 
    ((1.0085096944405725d0 2.0494828430055834d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
                           0.0 0.0 0.0)
     (1.0d0 0.0373231546472014d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0)) )
   (101 
    ((1.0205096611960442d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (103 
    ((1.0169553643166809d0 2.0549872179131707d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
                           0.0 0.0 0.0)
     (1.0d0 0.0436511130463239d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0
            0.0d0 0.0d0 0.0d0)) )
   (105 
    ((1.0089438180270995d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (107 
    ((1.0167962804290391d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) )
   (108 
    ((1.0055744128355328d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
     (1.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0 0.0d0)) ))
 :warn-not-found T)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; the unnormalised spectra
#|
(make-assoc-list
 'akoustik-piano-spectra
 '((21 ((0.0 2.0711345642522287d0 2.9406743544179923d0
          3.9432563710307327d0 4.988863189071091d0 0.0 6.985676163710781d0
          0.0 9.019547618122614d0 9.982987494233676d0 10.985379359678461d0
          11.995101918005851d0)
         (0.0 0.06903657593345974d0 0.20276219505527213d0 1.0d0
          0.5720771562459225d0 0.0 0.15812188646377978d0 0.0
          0.08608246076123945d0 0.05785283256827822d0
          0.26147182549588327d0 0.1849969485250867d0)))
    (23 ((1.0940507316113082d0 0.0 3.0663513262751176d0
          3.9058419341636834d0 0.0 5.901019688577144d0 6.952027720381207d0
          8.050503356869523d0 0.0 10.01434333724098d0 0.0
          12.019215491776087d0)
         (0.08240904067058266d0 0.0 0.7937360196495091d0 1.0d0 0.0
          0.6354286538657683d0 0.08290653879444912d0 0.08157717702873751d0
          0.0 0.14863129694328525d0 0.0 0.6486223463831698d0)))
    (24 ((0.9941203024657121d0 1.9624760970228483d0 2.9784004025120434d0
          3.9624122462265094d0 4.942077962136486d0 5.946691882018734d0
          6.930569589559592d0 7.976768994951194d0 8.978483247230155d0 0.0
          10.964575379771809d0 12.056748801999621d0)
         (0.05568730343259587d0 0.34179332286071284d0 1.0d0
          0.8444445072706013d0 0.24989816123886252d0 0.4909530200831979d0
          0.19993457687545083d0 0.05066034388715435d0
          0.10232295647287218d0 0.0 0.21688388691068125d0
          0.29021286407511016d0)))
    (26 ((0.951024237000931d0 2.046068219252724d0 2.955717027303568d0
          4.050471206344592d0 4.984235053942286d0 6.007770692316191d0
          7.024529244506904d0 0.0 9.082853725297584d0 9.984147960912784d0
          11.065796562247986d0 12.038813513843841d0)
         (0.03879506891980158d0 0.3429046342741457d0 1.0d0
          0.2502019720099307d0 0.46546731383677126d0 0.11796965143374741d0
          0.3338334425568532d0 0.0 0.017871304330194796d0
          0.28728167584652936d0 0.07829030980673277d0
          0.2000052003309094d0)))
    (28 ((0.0 2.0424077332956627d0 2.9890126541853914d0
          3.9898212370029125d0 4.972546896260217d0 6.0021297975115075d0
          7.053390984171799d0 7.998801429233497d0 9.008772021460736d0
          9.972168958664207d0 11.014719734640083d0 12.023544441213035d0)
         (0.0 0.8197794775855692d0 1.0d0 0.39972969021758686d0
          0.9134331040697843d0 0.6499870721172057d0 0.40613474316165665d0
          0.07933024351915574d0 0.32767784658509536d0
          0.43152610335341746d0 0.3314622112204652d0
          0.36037357696478356d0)))
    (29 ((0.0 1.9870434073902234d0 2.977456156034386d0
          3.9683974239200066d0 4.9617511431459d0 5.9834329241081425d0
          7.009405660566162d0 8.03702608790917d0 9.06389828530674d0
          10.083081340455808d0 11.084658768669238d0 12.057541977783792d0)
         (0.0 0.8702851998977778d0 0.9464265952939716d0 1.0d0
          0.3296966521921474d0 0.49416863200336675d0 0.1440782185336107d0
          0.05191420538144135d0 0.06538320061230485d0
          0.13919911668211957d0 0.16558510942579066d0
          0.09235083836331698d0)))
    (31 ((0.0 1.9828741796138631d0 3.094580216850941d0
          3.9551947007204404d0 5.06394624050625d0 5.984439593494791d0
          7.02425899863363d0 0.0 9.008342235914212d0 10.06344699378049d0
          11.046188299950456d0 12.05801266840112d0)
         (0.0 1.0d0 0.26681298910492873d0 0.566674586956232d0
          0.30366320700662497d0 0.3382836767160408d0 0.2661751157716173d0
          0.0 0.05871127024343243d0 0.16224759567688896d0
          0.15207868272019143d0 0.19753157847370986d0)))
    (33 ((0.9807924273962622d0 1.9731896527348665d0 2.9793287347687234d0
          3.961597260001885d0 5.047629993413228d0 6.052638190643145d0
          7.017736752736327d0 7.993484567886696d0 8.999632235556263d0
          10.02025590951863d0 11.04097143604789d0 12.069403702650494d0)
         (0.09822399762533708d0 1.0d0 0.3278737506981096d0
          0.1181895426991898d0 0.3231619886722972d0 0.35627089376459214d0
          0.07628225284069538d0 0.022378764630761733d0
          0.07952770763253002d0 0.19128765722151578d0
          0.19616600909974968d0 0.14302185436417134d0)))
    (35 ((1.0421015134684162d0 2.001952494216811d0 2.996590535998905d0
          3.9976610018227814d0 5.0368183873119206d0 6.031084425503747d0
          6.955852528908988d0 8.008674725403909d0 9.065957032470482d0
          10.079722912557122d0 10.975832516738857d0 12.01030035437235d0)
         (0.43748757693962587d0 0.7314628413741127d0 1.0d0
          0.1945118267848308d0 0.6545247627821774d0 0.32474601175621703d0
          0.06326872559283646d0 0.09515518495144555d0 0.2574252099883642d0
          0.3736579394807189d0 0.12738181350845335d0
          0.04190178431620863d0)))
    (36 ((0.9923722106532037d0 1.984381907617616d0 2.9797619222354315d0
          4.002305317942899d0 5.036879145327949d0 6.053869049569427d0
          7.071066177149901d0 8.044586596742306d0 9.054698695102685d0
          10.036795629003128d0 11.05326579399118d0 0.0)
         (0.9644747895165091d0 0.9821923290069122d0 0.3138863888284209d0
          0.27331322976697964d0 0.36616933145549363d0
          0.08114481915422665d0 0.2928579044705261d0 0.18138920534013714d0
          0.11511275625483608d0 0.23780652533763555d0
          0.08198935076910205d0 0.0)))
    (38 ((1.017334005563817d0 2.0268747024918436d0 3.01827715269107d0
          3.9969166670027305d0 5.006719558755829d0 6.02400764434256d0
          7.048100174741404d0 8.053115185477015d0 9.053314876597335d0
          10.090193777951209d0 11.07830381150209d0 12.08813505185287d0)
         (0.9576514173390335d0 0.9827919811597786d0 0.4744848359421187d0
          0.2191976815705493d0 0.17435049503778907d0 0.19643262666597341d0
          0.34124099303586236d0 0.07175100747247365d0
          0.03383027142841661d0 0.1019867040809325d0 0.06568969235612854d0
          0.05552135595775972d0)))
    (40 ((1.0280206910049596d0 1.9949655970232876d0 3.0088383033730346d0
          4.043339334600252d0 5.066029546394264d0 6.0255656122629615d0
          7.052582681000193d0 0.0 9.02690886852197d0 10.084949169452772d0
          0.0 11.965306970532579d0)
         (0.9081016443635739d0 0.9699632253181055d0 0.9862495625535268d0
          0.6832582041326565d0 0.20465645573332733d0 0.30307818138409165d0
          0.2169105627497275d0 0.0 0.057787004436877676d0
          0.22310508193446063d0 0.0 0.03451257292988684d0)))
    (41 ((0.994785530442185d0 1.9880974191295646d0 2.993044822960739d0
          3.9660376658535115d0 5.049418534718431d0 6.035817377691022d0
          7.031234866131952d0 7.992117629257727d0 9.003874488883014d0
          10.062082045635709d0 11.095989720056677d0 12.082764621781065d0)
         (0.6609964354886256d0 1.0d0 0.5504229654176399d0
          0.09556918551081982d0 0.20774983456590243d0
          0.25328521074302385d0 0.02704011497592325d0
          0.013050955729560203d0 0.053400502574775445d0
          0.11306624187658919d0 0.009631420301311018d0
          0.02484852155532617d0)))
    (43 ((0.9930596409244462d0 1.9887234667707123d0 3.001178386542311d0
          4.0254006794121215d0 5.050280758744143d0 6.043238446275825d0
          7.03078605199979d0 8.020450354299511d0 9.05582523151376d0
          10.067661894303253d0 11.093566013972652d0 0.0)
         (0.8674341018964963d0 1.0d0 0.24592838387199656d0
          0.34931162742212934d0 0.06959114541808187d0 0.1856032431713075d0
          0.25351059109234614d0 0.0220478646901419d0 0.04583455885720162d0
          0.03363678960837384d0 0.09691341103230713d0 0.0)))
    (45 ((0.9919869183731335d0 1.9529837299444461d0 3.0277331799302036d0
          4.019321562608279d0 5.036822191927045d0 6.059780620297709d0
          7.038462730716245d0 8.064989257027367d0 9.083181927065857d0
          10.08806543903808d0 0.0 0.0)
         (1.0d0 0.09188239968877314d0 0.7993105969667406d0
          0.46226708442781406d0 0.14419475844790217d0
          0.47589021411570975d0 0.19466417207466602d0
          0.07957272275651055d0 0.07237012465425786d0
          0.12465820013700761d0 0.0 0.0)))
    (47 ((1.0072268833787712d0 2.006488894400395d0 3.0224365668759554d0
          4.0084502922983d0 5.0438232384655945d0 6.0212358341638135d0
          7.049927260940666d0 8.033283097349559d0 9.071931549925294d0
          10.079762802497791d0 0.0 0.0)
         (0.5113829931077093d0 1.0d0 0.3684074410655617d0
          0.07875179780846163d0 0.186560544318681d0 0.27442464518466475d0
          0.0655936859188989d0 0.01780780732941453d0 0.02885953292387017d0
          0.032003384002145384d0 0.0 0.0)))
    (48 ((0.9935483634642207d0 1.994867864018912d0 2.9951333556829542d0
          4.02760545756282d0 5.017790985960185d0 6.019471802872981d0
          7.058119722616564d0 8.062465061957374d0 9.062068202859116d0
          10.095627657234788d0 0.0 0.0)
         (0.9580549189476869d0 1.0d0 0.13769475195218125d0
          0.44973163396356125d0 0.569277110752967d0 0.2699227603197636d0
          0.07087732373833677d0 0.027186814112755836d0
          0.026163583286672232d0 0.020175667607510134d0 0.0 0.0)))
    (50 ((1.0129760261465626d0 2.0007637639203932d0 3.0023809451195036d0
          4.030343848439467d0 5.034159731566996d0 6.0240298976951046d0
          7.038258521145217d0 8.062605729317916d0 9.089170396371202d0 0.0
          0.0 0.0)
         (1.0d0 0.5571960594119886d0 0.30522657859101177d0
          0.6476690969414072d0 0.3337509379578473d0 0.20736232440288424d0
          0.2011221139426381d0 0.12953350403966465d0 0.05655583266060676d0
          0.0 0.0 0.0)))
    (52 ((0.9936119024149889d0 2.019172641582346d0 3.0063747377967593d0
          4.021781917122785d0 5.032042656000189d0 6.033216568495658d0
          7.054322955574638d0 8.05532696238239d0 9.081731705036185d0 0.0
          0.0 0.0)
         (0.6081197931579592d0 1.0d0 0.9138298982874917d0
          0.30817943152712485d0 0.1542051235338561d0 0.21059182043395838d0
          0.02637976875954558d0 0.028676621425949983d0
          0.07373514243592035d0 0.0 0.0 0.0)))
    (53 ((0.9929983830628716d0 2.0194518077168486d0 3.0223271093986503d0
          4.0151614231254555d0 5.040362783694049d0 6.044573669741389d0
          7.060825070428483d0 8.072180038770403d0 9.075455845211033d0
          9.948308146989454d0 11.023767540669745d0 12.012915071674113d0)
         (1.0d0 0.42679166742146996d0 0.1700610846838131d0
          0.07314107224028854d0 0.17480870425340503d0
          0.07742666009208649d0 0.02173189075334885d0
          0.04097733351013034d0 0.007537235195200168d0
          0.0021453727686362688d0 0.003098644865367004d0
          0.0028142701174975744d0)))
    (55 ((0.994210422397459d0 2.0132019695338896d0 3.0210558333317663d0
          4.015687311876854d0 5.039882044756555d0 6.039546357242998d0
          7.07158530032154d0 8.066475488491532d0 8.923824905816279d0 0.0
          0.0 0.0)
         (1.0d0 0.30090596978098366d0 0.14949020297105417d0
          0.2991891065854226d0 0.25783644975071035d0 0.132037011897897d0
          0.13485379199073347d0 0.006373867656602468d0
          0.002383658517721399d0 0.0 0.0 0.0)))
    (57 ((1.0103484912366156d0 2.0081838579178295d0 3.030214961208891d0
          4.023074227197667d0 5.0416888186441895d0 6.064804763647608d0
          7.092374495478429d0 8.022955717342791d0 9.000786138908285d0 0.0
          0.0 0.0)
         (0.24754575980024254d0 1.0d0 0.20129491455946127d0
          0.11327307804231394d0 0.036283253264988755d0
          0.04074423526218555d0 0.033823574252705754d0
          0.002392359487740741d0 7.553359494427242d-4 0.0 0.0 0.0)))
    (59 ((1.0028947472095335d0 2.0061486644095634d0 3.0087932932874146d0
          4.014324997119126d0 5.026129435265955d0 6.056306127522819d0
          7.06781640545113d0 0.0 9.009421299887304d0 10.092721301005426d0
          11.012713177315419d0 12.03659282083084d0)
         (1.0d0 0.43295966283623283d0 0.17045717671168903d0
          0.14922448983877482d0 0.12092741795597318d0 0.1464127606296994d0
          0.13231862572085007d0 0.0 6.709389313018425d-4
          0.0018956544528355164d0 9.292535725606798d-4
          5.835749894757178d-4)))
    (60 ((0.9982489206168257d0 2.014263461548936d0 3.0090767036403947d0
          4.025891753079929d0 5.0391785223504755d0 6.051163469385689d0
          7.078870767769303d0 8.097071520583727d0 0.0 10.04537485275207d0
          0.0 12.001576621760098d0)
         (1.0d0 0.9110050427095994d0 0.13036526158661896d0
          0.02384098952910138d0 0.1068663706262658d0 0.03364125692496988d0
          0.06411071328728492d0 0.010625006807649204d0 0.0
          0.0016994831031129103d0 0.0 0.0018761371417123998d0)))
    (62 ((1.001238573965469d0 2.0147455500765044d0 3.015557241344336d0
          4.035054863133926d0 5.056127381396649d0 6.083410440384472d0
          7.0970875324313685d0 0.0 9.077534250737212d0 0.0
          11.061675385210705d0 11.982374547840925d0)
         (1.0d0 0.35333552437446647d0 0.08102691789642334d0
          0.2606116652722964d0 0.27892341706553064d0 0.06476651905686805d0
          0.031028794079644536d0 0.0 0.0035557282837508546d0 0.0
          0.0024282457945842524d0 0.00245860869630884d0)))
    (64 ((1.0093106860354546d0 2.0113883472952554d0 3.01057728707131d0
          4.026850554418135d0 5.038552118262078d0 6.070409450868894d0 0.0
          8.040800542519827d0 9.038872513490805d0 10.043891979812855d0
          10.995470291375396d0 12.003562778512295d0)
         (1.0d0 0.4406845268233989d0 0.13500465248811624d0
          0.025325759864971615d0 0.04125996554504429d0
          0.009047444349312884d0 0.0 0.002592348334512318d0
          0.0030261580800758263d0 0.0018854953773141698d0
          0.0017244703317479456d0 0.0015601458701090915d0)))
    (65 ((1.0107098209667444d0 2.0068750236137185d0 3.019647430063235d0
          4.040803439233032d0 5.055812913673791d0 6.080406119649338d0 0.0
          8.059233292823585d0 9.022764666204226d0 10.055776538357108d0
          10.965596701938757d0 12.030632769090715d0)
         (1.0d0 0.4471962908551291d0 0.14396436275241872d0
          0.12879399773466965d0 0.09732867113261258d0
          0.06931710504522827d0 0.0 0.002001457998580217d0
          0.0019201605996617083d0 0.0016908202998015367d0
          0.0016464075772317681d0 0.0014109866147559143d0)))
    (67 ((1.0103674269106484d0 2.00608653872613d0 3.021431134657277d0
          4.038792557457237d0 5.068349974941977d0 6.055773257935665d0
          6.985197903815203d0 0.0 9.016735299035817d0 10.012191858266261d0
          11.005098830276877d0 11.985419767322051d0)
         (1.0d0 0.12200660294289976d0 0.28815645938304163d0
          0.04700501301607774d0 0.010600717580960544d0
          0.016433258758504012d0 0.002135946387108406d0 0.0
          0.001536234413855598d0 0.0013796126350325757d0
          0.0012740330625415892d0 0.0011699482116259731d0)))
    (69 ((1.0041285558876951d0 2.0119952222867936d0 3.0306193709053866d0
          4.041877724525061d0 5.075558810256299d0 6.052114717163081d0
          6.983158961508278d0 8.042887426325917d0 9.035932389609833d0
          10.008496210046621d0 11.00339399989952d0 11.9965552852643d0)
         (1.0d0 0.1946741436541806d0 0.10739437136132919d0
          0.09428933288463448d0 0.037022969362679285d0
          0.0018022544339519207d0 0.001139088955912862d0
          8.3699479577235d-4 5.361228842968174d-4 6.35005736652828d-4
          5.667850542124782d-4 5.157810228484433d-4)))
    (71 ((1.0035413228886303d0 2.0097551624838705d0 3.029666040272755d0
          4.055013811681049d0 5.081765893116837d0 0.0 0.0
          8.021132453874866d0 9.037106751769205d0 10.032016345220544d0
          11.015050993109256d0 12.031998814030596d0)
         (1.0d0 0.20822520635987674d0 0.27194413992193994d0
          0.14407735055342066d0 0.07457885514415567d0 0.0 0.0
          0.0011071397886168739d0 6.440435070263303d-4
          5.301468415797066d-4 4.660181770600705d-4 4.196773850586268d-4)))
    (72 ((1.0077545288123213d0 2.015684001765782d0 3.028795913402981d0
          4.0541166000210085d0 5.08481145734531d0 6.05270516730125d0
          7.049265342709564d0 8.027816036626298d0 9.047799383799159d0
          10.042446853336724d0 11.025306719975015d0 12.045121423097111d0)
         (1.0d0 0.14671644531437034d0 0.04408956958105806d0
          0.055173963630863576d0 0.02867840677477496d0
          3.996476387475794d-4 4.453626353697294d-4 2.2047680856548922d-4
          2.6963625623289137d-4 2.3927282984223826d-4
          2.1331769526612452d-4 1.7760397191441104d-4)))
    (74 ((1.007988631862142d0 2.016643523706763d0 3.030956721461387d0
          4.065270519263744d0 0.0 5.951439628713636d0 7.013752690871896d0
          8.032477960181069d0 9.025014103936712d0 9.997350474300427d0
          11.049569632272673d0 0.0)
         (1.0d0 0.0756674920134841d0 0.00774288698502026d0
          0.030356416798996717d0 0.0 3.461008300794734d-4
          3.5753496092237857d-4 3.0655417878553776d-4
          2.6762479641850357d-4 2.410280011586127d-4 3.7013190162381526d-4
          0.0)))
    (76 ((1.0096803653841844d0 2.0159239644261593d0 3.035995827796937d0
          4.069732228671795d0 0.0 6.028506309748134d0 7.038178412548118d0
          8.023343954981861d0 9.012024256372328d0 9.987492235462591d0
          11.021177087571841d0 0.0)
         (1.0d0 0.19317859964633222d0 0.06295362912090402d0
          0.03576932297527697d0 0.0 0.0018316970416085883d0
          0.0014996270382168053d0 9.881375446972247d-4
          0.0014502278205639077d0 0.0013090218305552561d0
          0.0014474836392560754d0 0.0)))
    (77 ((1.0045989251496732d0 2.0187900795133693d0 3.0385524100367274d0
          4.073843673175793d0 5.0225682155387d0 6.02532151957487d0
          7.038182937321584d0 8.014050841830821d0 9.007918850904318d0 0.0
          0.0 0.0)
         (1.0d0 0.21554736754636075d0 0.1484521348499037d0
          0.04652509477857292d0 0.0013054829920279168d0
          8.050268746679462d-4 8.940163511115249d-4 7.7460843787597d-4
          9.61937739778498d-4 0.0 0.0 0.0)))
    (79 ((1.004588846079758d0 2.0188954555808425d0 3.0457964128463524d0
          4.08311080234874d0 5.042878984211835d0 6.016415857765595d0
          6.955609613477904d0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.1879355084753558d0 0.04724299309237664d0
          0.007026856464883426d0 7.973203496650697d-4 6.185590871901028d-4
          4.349553598024493d-4 0.0 0.0 0.0 0.0 0.0)))
    (81 ((1.0055854733874692d0 2.0190787605765643d0 3.0365398030860766d0
          4.071327909534851d0 4.998820117405864d0 5.992294895594008d0
          6.940053031449751d0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.15487644204634357d0 0.06043743520298417d0
          0.05604653484800995d0 0.001085229318626416d0
          9.572278224916414d-4 2.4399654760695543d-4 0.0 0.0 0.0 0.0 0.0)))
    (83 ((1.0070335991818167d0 2.0245284089693785d0 3.0527936748462245d0
          3.988297381210072d0 4.989741474848309d0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0)
         (1.0d0 0.552995334389942d0 0.2980809320711342d0
          0.0031621156197033534d0 0.0022286318774173007d0 0.0 0.0 0.0 0.0
          0.0 0.0 0.0)))
    (84 ((1.0070476572485603d0 2.0255610887457465d0 3.055381590700589d0
          4.023109458521526d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.3880903858468448d0 0.14750264094452673d0
          0.0018698420542705284d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
    (86 ((1.0089103848396315d0 2.0282889861384645d0 3.0680849090771125d0
          4.018371146253781d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.22057048278232347d0 0.018558698592665516d0
          6.870096575027823d-4 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
    (88 ((1.0055970086955996d0 2.014426926886691d0 3.005814699428225d0
          3.976428121894447d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.050998910708947014d0 0.0016948980913714905d0
          0.0010676141637186286d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
    (89 ((1.0112466697425966d0 2.0306718198193363d0 3.0460027237265965d0
          0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.044434043427843184d0 0.0010510197453662302d0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0 0.0 0.0)))
    (91 ((1.0093321325453954d0 2.015061061394972d0 3.0280062069052427d0
          0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)
         (1.0d0 0.01945672718417581d0 0.0010365407686369348d0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0 0.0 0.0)))
    (93 ((1.0106438128160187d0 2.019823563498926d0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0)
         (1.0d0 0.0069513349617835495d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0 0.0)))
    (95 ((1.0132571877733383d0 2.014166302906951d0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0)
         (1.0d0 0.01512430386295618d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0)))
    (96 ((1.0143515845499909d0 2.02631793606312d0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0)
         (1.0d0 0.007394443003673535d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
          0.0)))
    (98 ((1.0151539223908734d0 2.0331637002256238d0 0.0 0.0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0 0.0)
         (0.7135378688835963d0 0.0068849188014574805d0 0.0 0.0 0.0 0.0 0.0
          0.0 0.0 0.0 0.0 0.0)))
    (100 ((1.0085096944405725d0 2.0494828430055834d0 0.0 0.0 0.0 0.0 0.0
           0.0 0.0 0.0 0.0 0.0)
          (0.23612480081430265d0 0.008812922456831844d0 0.0 0.0 0.0 0.0
           0.0 0.0 0.0 0.0 0.0 0.0)))
    (101 ((1.0205096611960442d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)
          (0.6734905777064831d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)))
    (103 ((1.0169553643166809d0 2.0549872179131707d0 0.0 0.0 0.0 0.0 0.0
           0.0 0.0 0.0 0.0 0.0)
          (0.17070610612714213d0 0.007451511536253646d0 0.0 0.0 0.0 0.0
           0.0 0.0 0.0 0.0 0.0 0.0)))
    (105 ((1.0089438180270995d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)
          (0.03734266282192269d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)))
    (107 ((1.0167962804290391d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)
          (0.01800673724800772d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)))
    (108 ((1.0055744128355328d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0)
          (0.009784202463930016d0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
           0.0))))
 :warn-not-found T)
|#
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; EOF
