(require 'slime)
(add-hook 'lisp-mode-hook (lambda () (slime-mode t)))
(add-hook 'inferior-lisp-mode-hook (lambda () (inferior-slime-mode t)))

(setq inferior-lisp-program
      (concat (getenv "SC_RUNTIME") " --core " (getenv "SC_RUNTIME_CORE")
              " --sysinit " (getenv "SC_RUNTIME_INIT")))

(slime-setup '(slime-fancy))

;; (global-unset-key (kbd "C-3"))
;; (global-set-key (kbd "C-3") '(lambda() (interactive) (insert-string "#")))

;;; Use the right modes for various file extensions
(setq auto-mode-alist
      (append '(("\\.c$"  . c-mode)       
                ("\\.txt$"     . text-mode)
                ("\\.cpp$"     . c++-mode)
                ("\\.CPP$"     . c++-mode)
                ("\\.h$"     . c-mode)
                ("\\.lsp$"     . lisp-mode)
                ("\\.cm$"     . lisp-mode)
                ("\\.lisp$"     . lisp-mode)
                ("\\.lsp$"     . lisp-mode)
                ("\\.ins$"     . lisp-mode)
                ("\\.ws$"     . lisp-mode)
                ;; ("\\.html$"     . html-helper-mode)
                ("\\.htm$"     . html-mode)
                ("\\.shtml$"     . html-helper-mode)
                ("\\.js$"     . java-mode)
                ("\\.tex$"     . latex-mode)
                ("\\.java$"     . java-mode)
                ("\\.ascii$"   . text-mode)
                ("\\.sql$"   . sql-mode)
                ("\\.pl$"   . perl-mode)
                ("\\.php$"   . c++-mode))
              auto-mode-alist
              ))

(set-variable 'meta-flag 't)
(set-variable 'inhibit-startup-message' 't)
(toggle-text-mode-auto-fill)
(setq-default fill-column 80)
(define-key esc-map "?" 'describe-key-briefly)

(require 'saveplace)
(setq-default save-place t)
(setq make-backup-files nil)
(setq-default auto-fill-hook 'do-auto-fill)     
(setq debug-on-error t)
(setq case-fold-search t)   ; make searches case insensitive    
(global-set-key "\C-x\c" 'c-mode)
(global-set-key "\C-x\p" 'fi:pop-input)
(global-set-key "\C-x\C-a" 'auto-fill)
(global-set-key "\C-x\z" 'query-replace)
(global-set-key "\C-c\l" 'goto-line)
(global-set-key "\C-x\l" '(lambda () (interactive)
                            (switch-to-buffer "*slime-repl sbcl*")))
(global-set-key "\M-," 'tags-loop-continue)
(global-set-key "\C-c\w" 'what-line)
(global-set-key "\C-c\C-s" 'spell-buffer)
(global-set-key "\C-c\C-i" 'indent-sexp)
(global-set-key "\C-c\r" 'revert-buffer)
(global-set-key "\C-c\C-f" 'auto-fill-mode)
(global-set-key "\C-c\p" 'pipe-to-lisp)
(global-set-key "\C-c\C-m" 'manual-entry)
(global-set-key "\C-x\x" 'current-column)
(global-set-key "\C-c\i" 'set-c-indent)
(global-set-key "\C-c\j" 'set-java-indent)
(global-set-key "\C-c\C-y" 'tags-search)
(global-set-key "\M-," 'tags-loop-continue)
(global-unset-key "\C-x\C-s")
;; (global-set-key "\C-x\C-s" 'detab)
(global-set-key "\C-x\C-t" 'pdflatex)
(global-set-key "\C-c\c" 'compile)
(global-set-key "\C-x\t" 'latex2html)
(global-unset-key "\C-c\C-t")
(global-set-key "\C-x\C-d" 'short-timestamp)
(global-set-key "\C-x\C-y" 'insert-clos-class-keywords)
(global-set-key "\C-c\C-c" 'calendar)
(global-set-key "\C-c\C-d" 'diary)
(global-set-key "\M-3" '(lambda() (interactive) (insert-string "#")))
(global-set-key "\M-," 'tags-loop-continue)

