;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File:             cavatina.lsp
;;;
;;; Class Hierarchy:  None
;;;
;;; Version:          1.0
;;;
;;; Project:          slippery chicken (algorithmic composition)
;;;
;;; Purpose:          Proof-of-concept code for tonal composition with sc
;;;
;;; Author:           Sean Reed
;;;
;;; Creation date:    23rd August 2012
;;;
;;; $$ Last modified: 22:40:41 Fri May 17 2013 BST
;;;
;;; SVN ID: $Id: cavatina.lsp 3538 2013-05-18 08:29:15Z medward2 $
;;;
;;; ****
;;; Licence:          Copyright (c) 2012 Michael Edwards
;;;
;;;                   This file is part of slippery-chicken
;;;
;;;                   slippery-chicken is free software; you can redistribute it
;;;                   and/or modify it under the terms of the GNU General
;;;                   Public License as published by the Free Software
;;;                   Foundation; either version 3 of the License, or (at your
;;;                   option) any later version.
;;;
;;;                   slippery-chicken is distributed in the hope that it will
;;;                   be useful, but WITHOUT ANY WARRANTY; without even the
;;;                   implied warranty of MERCHANTABILITY or FITNESS FOR A
;;;                   PARTICULAR PURPOSE.  See the GNU General Public License
;;;                   for more details.
;;;
;;;                   You should have received a copy of the GNU General Public
;;;                   License along with slippery-chicken; if not, write to the
;;;                   Free Software Foundation, Inc., 59 Temple Place, Suite
;;;                   330, Boston, MA 02111-1307 USA
;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :sc)
(in-scale :chromatic)

;;; beethoven cavatina

(let* ((sp '(((1 ((ef2 e2 f2 bf2 d3 f3 g3 bf3 f4 g4 af4 bf4 c5)))
              (2 ((ef2 f2 g2 d3 ef3 bf3 g4 af4 bf4)))
              (3 ((af2 a2 c3 ef3 f3 g3 c4 f4 g4 af4 b4 c5 d5)))
              (4 ((ef2 f2 af2 bf2 d3 bf3 d4 ef4 f4 g4 af4)))
              (5 ((ef2 f2 g2 g3 af3 bf3 ef4 bf4 d5 ef5)))
              (6 ((d2 b2 c3 ef3 f3 bf3 d4 ef4 f4 g4 af4 f5)))
              (7 ((e2 f2 g2 af2 f3 g3 bf3 c4 ef4 f4 g4 af4 bf4 c5)))  
              (8 ((c2 d2 bf2 ef3 f3 bf3 ef4 f4 g4 bf4)))
              (9 ((c2 d2 ef2 ef3 f3 g3 bf3 ef4 f4 g4 bf4)))
              (10 ((ef2 f2 g2 af2 bf2 d3 ef3 g3 bf3 d4 ef4 f4 g4 af4 bf4 c5)))
              (11 ((ef2 f2 g2 d3 ef3 bf3 ef4 g4 af4 bf4)))
              (12 ((g2 b2 c3 d3 g3 b3 c4 d4 ef4 f4 g4)))
              (13 ((f2 g2 af3 bf3 c4 d4 ef4 e4)))
              (14 ((af2 a2 c3 d3 f3 c4 e4 f4 fs4 c5)))
              (15 ((f2 g2 ef3 c4 g4 af4)))
              (16 ((f2 g2 ef3 c4 g4 af4)))
              (17 ((g2 d3 ef3 g3 b3 c4 d4 f4 g4 af4 b4)))
              (18 ((c3 g3 bf3 c4 df4 e4 c5)))
              (19 ((f3 af3 a3 c4 f4 a4 c5 ef5 f5 gf5)))
              (20 ((f3 af3 bf3 c4 f4 bf4 d5 ef5 f5)))
              (21 ((f2 af2 bf2 c3 d3 bf3 d4 f4 g4 af4 bf4 d5 ef5 f5)))
              (22 ((d2 bf2 c3 d3 ef3 f3 bf3 af4 a4 bf4 f5)))
              (23 ((g2 af2 c3 ef3 g3 ef4 g4 af4 bf4)))
              (24 ((af2 bf2 d3 ef3 f3 bf3 f4 g4 af4 bf4 c5)))
              (25 ((g2 af2 c3 ef3 g3 bf3 c4 ef4 g4 af4 bf4)))
              (26 ((af2 bf2 c3 d3 ef3 f3 bf3 ef4 f4 g4 af4 bf4 c5 d5)))
              (27 ((ef2 g2 bf2 c3 ef3 g3 bf3 ef4 bf4 b4 ef5 g5)))
              (28 ((af2 c3 ef3 f3 af3 b3 c4 ef4 b4 c5 d5 ef5)))
              (29 ((a2 bf2 c3 f3 g3 bf3 c4 d4 ef4 g4 af4 bf4 c5 ef5)))
              (30 ((ef2 bf2 d3 ef3 f3 g3 bf3 d4 ef4 g4 af4 bf4)))
              (31 ((ef2 ef3 f3 g3 af3 bf3 c4 g4 af4 bf4)))
              (32 ((g2 af2 c3 ef3 f3 g3 bf3 ef4 g4 af4 bf4)))
              (33 ((af2 bf2 c3 d3 ef3 bf3 f4 g4 af4 bf4 c5)))
              (34 ((g2 af2 c3 ef3 g3 bf3 c4 ef4 g4 af4 bf4)))
              (35 ((af2 a2 bf2 ef3 f3 bf3 c4 d4 f4 g4 af4 bf4 c5 d5)))
              (36 ((ef2 g2 bf2 c3 ef3 g3 bf3 ef4 bf4 b4 ef5 g5)))
              (37 ((c2 g2 af2 c3 ef3 f3 af3 b3 c4 b4 c5 d5 ef5)))
              (38 ((a2 bf2 d3 ef3 f3 af3 bf3 c4 ef4 f4 g4 af4 c5 ef5)))
              (39 ((d2 ef2 d3 ef3 g3 af3 bf3 f4 g4 ef4 f4 g4)))
              (40 ((ef2 ef3 ef4)))
              (41 ((df2 ef3 ef4 gf4)))
              (42 ((cf3 ef3 cf4 ef4 gf4 cf5 df5 ef5)))
              (43 ((ff2 df3 cf4 af4 df5 ff5 gf5 af5)))
              (44 ((gf2 df3 bf3 df4 ff4 gf4 g4 af4 af5)))
              (45 ((g2 af2 ef3 bf3 cf3 df4 ef4 bf4 cf5 df5 ef5)))
              (46 ((g2 af2 ef3 bf3 cf4 ef4 bf4 cf5 df5 ef5)))
              (47 ((ef2 ff2 af2 df3 ef3 af3 cf4 df4 ef4 af4 g4 af4 cf5 ef5)))
              (48 ((ef2 ff2 df3 g3 bf3 df4 g4 af4 bf4)))
              (49 ((ef2 g2 bf2 ef3 e3 f3 g3 af3 bf3 d4 f4 g4 af4 bf4 c5)))
              (50 ((ef2 f2 g2 d3 ef3 g3 bf3 ef4 g4 af4 bf4)))
              (51 ((af2 a2 ef3 e3 f3 c4 f4 g4 af4 b4 c5 d5)))
              (52 ((f2 g2 af2 bf2 d3 ef3 f3 bf3 f4 g4 af4)))
              (53 ((ef2 f2 g2 ef3 bf3 ef4 g4 af4 bf4 d5 ef5)))
              (54 ((d2 b2 c3 ef3 f3 bf3 d4 ef4 f4 g4 af4 f5)))
              (55 ((e2 f2 g2 af2 f3 g3 bf3 c4 ef4 f4 g4 af4 bf4 c5)))
              (56 ((c2 d2 bf2 ef3 f3 g3 bf3 ef4 f4 g4 bf4)))
              (57 ((c2 d2 ef2 bf2 ef3 f3 g3 bf3 ef4 f4 g4 bf4)))
              (58 ((ef2 f2 af2 bf2 c3 d3 f3 g3 af3 bf3 bf4 ef5 f5)))
              (59 ((ef2 bf2 d3 ef3 af3 bf3 c4 f4 g4 af4 ef5 f5 g5)))
              (60 ((c3 ef3 af3 bf3 c4 ef4 f4 g4 af4 bf4 c5 d5)))
              (61 ((f3 g3 af3 bf3 ef4 f4 d5 ef5 f5 af5 bf5 c6)))
              (62 ((d2 f2 g2 af2 ef3 af3 bf3 f4 g4 af4 bf4 c5 ef5 f5)))
              (63 ((c2 df2 bf2 cf3 ef3 f3 g3 d4 ef4 f4 g4 af4 bf4)))
              (64 ((bf2 d3 ef3 f3 g3 bf3 d4 ef4 f4 g4 af4)))
              (65 ((d3 ef3 f3 g3 af3 bf3 ef4 f4 g4 bf4 ef5)))
              (66 ((ef2 bf2 ef3 g3 bf3 g4 af4))))     
             :recurse-simple-data nil))
       (lims-pchs '(((BF3 G4) (F4 C5) (D3 G3) (EF2 BF2))
                    ((G4 BF4) (BF3 BF3) (D3 EF3) (EF2 EF3))
                    ((F4 G4) (C4 D5) (C3 G3) (AF2 A2)) 
                    ((F4 AF4) (D4 F4) (D3 BF3) (EF2 BF2))
                    ((BF4 EF5) (BF3 EF4) (G3 BF3) (EF2 G3))
                    ((G4 F5) (BF3 F4) (EF3 F3) (D2 C3)) 
                    ((F4 C5) (C4 G4) (F3 C4) (E2 AF2))
                    ((F4 BF4) (BF3 EF4) (EF3 F4) (C2 BF2))
                    ((EF4 EF4) (BF3 BF4) (EF3 AF3) (C2 EF2))
                    ((BF3 G4) (EF4 C5) (D3 D4) (EF2 BF2))
                    ((G4 BF4) (BF3 BF3) (D3 EF4) (EF2 G2)) 
                    ((EF4 G4) (B3 D4) (D3 G3) (G2 C3))
                    ((D4 E4) (C4 C4) (AF3 BF3) (F2 G2)) 
                    ((E4 C5) (C4 FS4) (C3 F3) (AF2 A3))
                    ((G4 AF4) (C4 C4) (EF3 EF3) (F2 G2)) 
                    ((G4 G4) (C4 AF4) (EF3 EF3) (F2 G2))
                    ((G4 B4) (B3 AF4) (D3 G3) (G2 G2)) 
                    ((E4 C5) (C4 E4) (G3 DF4) (C3 C3))
                    ((F4 A4) (C4 GF5) (AF3 F4) (F3 F4)) 
                    ((BF4 F5) (BF4 D5) (F4 F4) (F3 C4))
                    ((AF4 F5) (F4 F5) (BF3 AF4) (F2 D3)) 
                    ((AF4 F5) (AF4 F5) (D3 BF3) (D2 D3))
                    ((AF4 F5) (EF4 BF4) (C3 G3) (G2 C3))
                    ((BF4 C5) (F4 AF4) (D3 F3) (AF2 BF2))
                    ((EF4 BF4) (G3 C4) (EF3 EF3) (G2 C3))
                    ((F4 D5) (BF3 F4) (C3 F3) (AF2 BF2))
                    ((EF4 G5) (EF4 EF4) (EF3 EF3) (EF2 C3))
                    ((B4 EF5) (B3 EF4) (C3 F3) (AF2 AF2))
                    ((G4 EF5) (BF3 EF4) (C3 G3) (A2 BF2))
                    ((G4 BF4) (D4 BF4) (D3 BF3) (EF2 EF3))
                    ((G4 BF4) (G4 BF4) (F3 AF3) (EF2 F3))
                    ((EF4 BF4) (EF4 BF4) (EF3 EF4) (G2 G3))
                    ((bf4 c5) (bf3 af4) (d3 ef3) (af2 c3))
                    ((ef4 bf4) (g3 g4) (ef3 ef3) (g2 c3))
                    ((f4 d5) (bf3 d4) (ef3 f3) (af2 bf2))
                    ((ef4 g5) (bf3 ef4) (ef3 g3) (ef2 c3))
                    ((b4 ef5) (b3 c4) (c3 af3) (c2 af2))
                    ((f4 ef5) (af3 ef4) (d3 f3) (a2 bf2))
                    ((ef4 g4) (g3 g4) (d3 af3) (d2 ef2))
                    ((ef4 ef4) (ef4 ef4) (ef3 ef3) (ef2 ef2))
                    ((gf4 gf4) (ef4 ef4) (ef3 ef3) (df2 df2))
                    ((gf4 ef5) (ef4 gf4) (ef3 cf4) (cf3 cf3))
                    ((df5 af5) (af4 af4) (df3 cf4) (ff2 ff2))
                    ((ff4 af5) (df4 df4) (df3 df3) (gf2 gf2))
                    ((ef4 ef5) (bf3 ef4) (ef3 bf3) (g2 af2))
                    ((ef4 ef5) (bf3 cf4) (ef3 ef3) (g2 af2))
                    ((g4 ef5) (af3 af4) (df3 df4) (ef2 af2))
                    ((bf4 bf4) (bf3 bf4) (df3 df4) (ef2 ff2))
                    ((bf3 g4) (f4 c5) (ef3 d4) (ef2 bf2))
                    ((g4 bf4) (bf3 bf3) (d3 g3) (ef2 ef3))
                    ((f4 g4) (c4 d5) (ef3 f3) (af2 a2))
                    ((f4 af4) (bf3 bf3) (d3 f3) (f2 bf2))
                    ((bf4 ef5) (bf3 af4) (ef3 bf3) (ef2 g2))
                    ((g4 f5) (d4 f4) (ef3 bf3) (d2 c3))
                    ((f4 c5) (c4 g4) (f3 c4) (e2 af2))
                    ((f4 bf4) (bf3 ef4) (ef3 bf3) (c2 bf2))
                    ((ef4 bf4) (bf3 bf4) (ef3 bf3) (c2 ef2))
                    ((bf4 f5) (bf3 bf3) (d3 af3) (ef2 c3))
                    ((ef5 g5) (af3 af4) (d3 c4) (ef2 ef3))
                    ((f4 d5) (c4 af4) (ef3 bf3) (c3 bf3))
                    ((d5 ef5) (ef4 c6) (f3 bf3) (bf3 f4))
                    ((ef5 f5) (f4 c5) (ef3 bf3) (d2 g4))
                    ((f4 bf4) (d4 ef4) (ef3 g3) (c2 cf3))
                    ((ef4 g4) (bf3 af4) (d3 g3) (bf2 bf3))
                    ((ef4 ef5) (bf3 g4) (d3 bf3) (ef3 af3))
                    ((g4 af4) (bf3 g4) (ef3 g3) (ef2 ef3))))
       (lims-lists (loop for n in '(first second)
                      collect
                        (loop for pl in '(vo vt va vc)
                           for i from 0
                           collect 
                             (list pl
                                   (loop for pchs in lims-pchs
                                      for b from 1
                                      collect b
                                      collect (funcall n (nth i pchs)))))))
       (cavatina
        (make-slippery-chicken
         '+cavatina+
         :title "Cavatina"
         :composer "Ludwig van Beethoven"
         :tempo-map '((1 (q 52 "Adagio molto espressivo")))
         :key-sig '(ef major)
         :bars-per-system-map '((1 6) (7 7) (21 6) (27 7) (34 6) (40 5) (45 4)
                                (49 6))
         :ensemble '(((vo (violin :midi-channel 1))
                      (vt (violin :midi-channel 2))
                      (va (viola :midi-channel 3))
                      (vc (cello :midi-channel 4))))
         :set-palette sp
         :set-map (list (list 1 (loop for b from 1 to (length (first sp))
                                   collect b)))
         :set-limits-low (first lims-lists)
         :set-limits-high (second lims-lists)
         :avoid-melodic-octaves nil
         :avoid-used-notes nil
         :rthm-seq-palette '((1 ((((3 4) (q) (q) - e. s -))
                                 :pitch-seq-palette ((1 3) (1 5) (1 4))))
                             (2 ((((3 4) - e e e e e e -))
                                 :pitch-seq-palette ((2 4 5 4 3 1) 
                                                     (1 5 7 6 4 3) 
                                                     (2 1 5 4 3 2) 
                                                     (1 5 6 5 4 2)
                                                     (3 2 1 2 1 5) 
                                                     (1 3 4 3 2 5)
                                                     (2 1 6 5 4 3) 
                                                     (1 3 4 3 2 1)
                                                     (1 6 7 6 5 4) 
                                                     (1 3 4 3 2 1)
                                                     (5 3 4 3 2 1) 
                                                     (1 4 4 3 3 2)
                                                     (1 2 2 3 3 4) 
                                                     (3 2 2 1 1 2)
                                                     (1 2 2 3 3 4) 
                                                     (2 1 2 3 3 2)
                                                     (2 1 1 3 4 5) 
                                                     (1 2 2 4 4 3)
                                                     (4 4 5 4 3 1)
                                                     (1 5 7 6 4 3)
                                                     (2 1 5 4 3 2)
                                                     (3 3 4 3 2 1)
                                                     (1 4 5 4 3 2)
                                                     (2 5 6 5 4 1)
                                                     (2 4 5 4 3 1)
                                                     (3 2 1 5 4 6)
                                                     (1 7 8 7 6 5)
                                                     (2 2 3 2 1 4)
                                                     (4 4 5 4 3 1)
                                                     (9 3 4 3 2 1)
                                                     (1 2 5 6 4 4)
                                                     (4 3 2 3 1 1)))) 
                             (3 ((((3 4) h - e e -))
                                 :pitch-seq-palette ((3 2 1))))
                             (4 ((((3 4) q q - e e -))
                                 :pitch-seq-palette ((1 2 3 4) (4 1 2 3)
                                                     (4 1 2 3) (1 3 4 1)
                                                     (3 1 1 2) (2 2 1 2)
                                                     (2 2 1 2) (4 1 3 2)
                                                     (4 3 2 1) (1 2 1 3)
                                                     (4 2 1 3) (1 2 4 3)
                                                     (4 1 2 3))))
                             (5 ((((3 4) q. e - e s s -))
                                 :pitch-seq-palette ((1 2 3 2 1) (1 2 3 2 1)
                                                     (1 2 3 2 1) (1 2 3 2 1)
                                                     (1 2 3 2 1))))
                             (6 ((((3 4) q q q))
                                 :pitch-seq-palette ((1 1 1) (2 1 2) (3 2 1)
                                                     (1 2 3) (2 1 1) (3 2 1)
                                                     (3 2 1) (2 2 1) (1 2 3)
                                                     (3 1 2) (3 1 2) (3 1 2)
                                                     (1 2 3) (1 3 2) (1 2 2) 
                                                     (1 2 3) (1 1 1) (1 2 2) 
                                                     (1 2 2) (1 2 1) (2 3 1) 
                                                     (1 3 2) (2 1 3) (1 1 1)
                                                     (1 3 2) (1 1 1) (1 1 1)
                                                     (1 1 1) (1 2 2) (1 4 2)
                                                     (1 2 3) (1 2 3) (4 1 3) 
                                                     (1 1 1) (1 3 2) (1 2 3)
                                                     (1 1 2) (3 2 1) (1 2 2) 
                                                     (2 1 1) (3 2 1) (1 2 2)
                                                     (1 2 3) (1 1 1) (3 1 2)
                                                     (1 2 3) (3 2 1) (3 1 2) 
                                                     (1 2 3) (3 1 2) (3 1 2)
                                                     (3 1 2) (3 1 2))))
                             (7 ((((3 4) - e e - q q))
                                 :pitch-seq-palette ((5 1 2 3) (1 2 2 2)
                                                     (1 4 2 3) (4 2 1 2)
                                                     (2 3 1 1) (1 2 3 2)
                                                     (6 1 3 2) (3 4 2 1)
                                                     (5 1 2 3) (1 2 4 3)
                                                     (1 2 2 2) (3 2 2 1)
                                                     (4 3 1 2))))
                             (8 ((((3 4) - s e. - (q) (q)))
                                 :pitch-seq-palette ((2 1) (2 1))))
                             (9 ((((3 4) - e e - q - e e -))
                                 :pitch-seq-palette ((1 4 3 1 2)
                                                     (3 4 2 1 1))))
                             (10 ((((3 4) q. - e e e -))
                                  :pitch-seq-palette ((1 1 1 2) (1 4 3 2)
                                                      (2 2 1 2) (1 2 3 1)
                                                      (1 1 1 2) (1 4 3 2)))) 
                             (11 ((((3 4) q q. e))
                                  :pitch-seq-palette ((3 2 1) (1 2 1) 
                                                      (3 2 1))))
                             (12 ((((3 4) q - e e e e -))
                                  :pitch-seq-palette ((1 2 4 4 3)
                                                      (3 4 2 2 1))))
                             (13 ((((3 4) e q - e e e -))
                                  :pitch-seq-palette ((2 4 2 1 2) (1 5 4 3 4)
                                                      (3 2 3 1 1) (4 1 4 5 7)
                                                      (2 3 2 1 2) (1 5 4 3 4)
                                                      (1 3 3 3 2))))
                             (14 ((((3 4) q - e e - q))
                                  :pitch-seq-palette ((2 2 1 1) (2 2 3 1)
                                                      (1 2 3 3) (3 1 2 4)
                                                      (2 3 1 4) (2 2 1 1)
                                                      (2 3 2 1) (2 3 1 4)))) 
                             (15 ((((3 4) h q))
                                  :pitch-seq-palette ((1 2) (1 1) (2 1))))
                             (16 ((((3 4) q (q) (q)))
                                  :pitch-seq-palette ((1) (1) (1))))
                             (17 ((((3 4) e q e q))
                                  :pitch-seq-palette ((1 1 1 1) (2 1 4 3))))
                             (18 ((((3 4) - e e - (e) - e e e -))
                                  :pitch-seq-palette ((2 1 1 1 3))))
                             (19 ((((3 4) - e e - (e) e - e. s -))
                                  :pitch-seq-palette ((1 2 4 4 3))))
                             (20 ((((3 4) q h))
                                  :pitch-seq-palette ((1 2) (1 1) (1 1) (2 1)
                                                      (1 3) (1 2))))
                             (21 ((((3 4) - e e - h))
                                  :pitch-seq-palette ((1 2 3) (1 1 1) 
                                                      (2 2 1))))
                             (22 ((((3 4) - e e - (q) e (e)))
                                  :pitch-seq-palette ((2 1 3) (1 2 4))))
                             (23 ((((3 4) q (q) e (e)))
                                  :pitch-seq-palette ((1 1) (3 1))))
                             (24 ((((3 4) - e. s - h))
                                  :pitch-seq-palette ((2 1 1))))
                             (25 ((((3 4) e (e) (q) e (e)))
                                  :pitch-seq-palette ((1 1) (1 1))))
                             (26 ((((3 4) q q. - s s -))
                                  :pitch-seq-palette ((1 2 3 4))))
                             (27 ((((3 4) e (e) e (e) e (e)))
                                  :pitch-seq-palette ((2 1 1) (1 1 1))))
                             (28 ((((3 4) - e. s - q (q)))
                                  :pitch-seq-palette ((5 1 1) (2 3 1))))
                             (29 ((((3 4) e (e) e q - s s -))
                                  :pitch-seq-palette ((4 1 5 6 7)
                                                      (2 1 2 4 5))))
                             (30 ((((3 4) - e. s - q - e e -))
                                  :pitch-seq-palette ((4 1 1 2 3))))
                             (31 ((((3 4) - e. s - - e e e e -))
                                  :pitch-seq-palette ((4 3 3 2 2 1))))
                             (32 ((((3 4) q q { 3 - te te te - }))
                                  :pitch-seq-palette ((4 1 4 3 2) (4 1 4 3 2)
                                                      (4 1 4 3 2))))
                             (33 ((((3 4) (q) (q) - e e -))
                                  :pitch-seq-palette ((2 1) (2 1))))
                             (34 ((((3 4) - e s s - q - e s s -))
                                  :pitch-seq-palette ((2 4 3 1 6 5 4))))
                             (35 ((((3 4) - e e - q. - s s -))
                                  :pitch-seq-palette ((2 1 5 4 3))))
                             (36 ((((3 4) q - e e - - e e -))
                                  :pitch-seq-palette ((2 2 3 3 1) (1 2 3 5 4) 
                                                      (3 4 5 1 3) 
                                                      (2 2 1 1 2))))
                             (37 ((((3 4) - e s. 32 - q - e e -))
                                  :pitch-seq-palette ((5 4 1 1 3 2)
                                                      (5 4 2 2 3 1))))
                             (38 ((((3 4) - e e - - e e - q))
                                  :pitch-seq-palette ((2 4 4 1 3) 
                                                      (2 3 3 2 1))))
                             (39 ((((3 4) - e. s - e q e))
                                  :pitch-seq-palette ((2 3 1 3 3))))
                             (40 ((((3 4) (h.)))))
                             (41 ((((3 4) - e e - q - e s s -))
                                  :pitch-seq-palette ((2 3 1 6 5 4))))
                             (42 ((((3 4) - e e - q. - s. 32 -))
                                  :pitch-seq-palette ((2 1 5 4 3))))
                             (43 ((((3 4) - e e - q (q)))
                                  :pitch-seq-palette ((2 3 1) (2 3 1))))
                             (44 ((((3 4) { 3 - te te te - } { 3 - te te te - }
                                    { 3 - te te te - } ))
                                  :pitch-seq-palette ((1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 2 2 2 2 2 2 2 2)
                                                      (1 1 1 1 1 1 1 1 2)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (3 3 3 1 1 1 2 2 2)
                                                      (2 2 2 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 2 2 2)
                                                      (1 1 1 1 1 1 2 2 2)
                                                      (1 1 1 1 1 1 1 1 1)
                                                      (1 1 1 1 1 1 2 2 2))))
                             (45 ((((3 4) (q) h))
                                  :pitch-seq-palette ((1))))
                             (46 ((((3 4) - e +s s - (e) - s. 32 - (e) e))
                                  :pitch-seq-palette (1 2 2 3 4)))
                             (47 ((((3 4) (e) e (e) - s. 32 - (e) e))
                                  :pitch-seq-palette ((1 2 3 4))))
                             (48 ((((3 4) (e) e - +s s s s - - s s - (s) s))
                                  :pitch-seq-palette ((5 4 3 2 1 1 1))))
                             (49 ((((3 4) (s) - s (s) s - (s) - s s s - - s s - 
                                    (s) s))
                                  :pitch-seq-palette ((1 2 2 5 4 4 2 3))))
                             (50 ((((3 4) (s) - 32 32 - (s) - 32 32 - (s) 
                                    - 32 32 - (s) - 32 32 - - s e s -))
                                  :pitch-seq-palette ((1 1 2 2 5 5 4 4 4 2
                                                         3))))
                             (51 ((((3 4) - e e - q. e))
                                  :pitch-seq-palette ((1 3 4 5) (2 1 3 2))))
                             (52 ((((3 4) - e s s - h))
                                  :pitch-seq-palette ((4 3 1 2))))
                             (53 ((((3 4) { 3 - te te te - } h))
                                  :pitch-seq-palette ((3 4 1 1) (3 1 1 2))))
                             (54 ((((3 4) { 3 - te te te - } q q))
                                  :pitch-seq-palette ((2 2 2 1 5))))
                             (55 ((((3 4) q. q e))
                                  :pitch-seq-palette ((1 1 1))))
                             (56 ((((3 4) q - +e e - +q))
                                  :pitch-seq-palette ((2 1))))
                             (57 ((((3 4) q (q) q))
                                  :pitch-seq-palette ((1 4))))
                             (58 ((((3 4) q. e q))
                                  :pitch-seq-palette ((1 2 3) (2 2 1) (1 2 3))))
                             (59 ((((3 4) q (e) e q))
                                  :pitch-seq-palette ((3 1 2))))
                             (60 ((((3 4) - e e e e - q))
                                  :pitch-seq-palette ((1 4 3 4 2))))
                             (61 ((((3 4) e (e) - e e e e -))
                                  :pitch-seq-palette ((2 1 5 4 3))))
                             (62 ((((3 4) e (e) q - e e -))
                                  :pitch-seq-palette ((1 2 3 2))))
                             (63 ((((3 4) e (e) q q))
                                  :pitch-seq-palette ((1 3 4))))
                             (64 ((((3 4) q. - s s - q))
                                  :pitch-seq-palette ((1 1 2 2))))
                             (65 ((((3 4) q. e { 3 - te te te - } ))
                                  :pitch-seq-palette ((4 3 2 3 1))))
                             (66 ((((3 4) q - e e - - e s s -))
                                  :pitch-seq-palette ((2 1 5 5 6 4) 
                                                      (3 4 2 2 3 1))))
                             (67 ((((3 4) q q (e) e))
                                  :pitch-seq-palette ((1 3 6))))
                             (68 ((((3 4) (e.) s q. e))
                                  :pitch-seq-palette ((1 5 4))))
                             (69 ((((3 4) - s e. - +e (q) (e)))
                                  :pitch-seq-palette ((2 1))))
                             (70 ((((3 4) q - e +e +e +e -))
                                  :pitch-seq-palette ((1 2) (2 1) (3 1)))))  
         :rthm-seq-map '((1 ((vo (1 5 8 5 6 11 2 13 16 1 5 13 18 19 20 16 20 24
                                    20 26 28 40 40 33 32 34 35 2 37 28 40 40 33
                                    32 41 42 2 37 43 40 45 46 47 48 49 50 52 16
                                    1 5 8 5 6 11 2 13 57 58 59 2 58 64 65 43 68
                                    69))
                             (vt (2 6 2 6 6 7 10 14 13 2 17 6 6 4 20 21 2 23 2
                                    27 29 30 32 7 6 14 6 2 38 36 39 4 7 6 6 6
                                    36 12 2 44 44 44 44 44 44 44 53 51 2 6 2 55
                                    7 6 10 56 13 15 2 61 2 2 15 66 9 70))
                             (va (3 6 9 7 6 6 12 15 6 2 7 6 6 4 20 21 22 2 22
                                    27 29 31 6 14 6 14 6 36 7 36 6 4 14 6 6 6 2
                                    38 2 44 44 44 44 44 44 44 54 51 13 6 10 4 7
                                    7 4 7 6 2 2 62 2 13 6 66 2 70))
                             (vc (4 7 10 4 6 6 4 6 6 2 6 6 6 6 20 21 23 25 25 2
                                    2 2 6 4 6 4 14 6 6 6 6 7 14 6 6 14 6 6 10
                                    44 44 44 44 44 44 44 53 11 6 7 10 4 6 6 4 6
                                    6 2 60 63 58 2 17 67 2 70))))))))
  ;; add double-stops
  (loop for ds in '((4 2 vc (ef2 bf2)) (4 3 vc (f2 bf2)) (8 2 vc (c2 bf2))
                    (8 3 vc (d2 bf2)) (9 2 va (ef3 bf3)) (9 3 va (f3 bf3))
                    (9 1 vc (ef2 bf2)) (9 2 vc (c2 bf2)) (9 3 vc (d2 bf2))
                    (10 1 va (g3 bf3)) (10 1 vc (ef2 bf2)) (11 1 vt (bf3 ef4))
                    (16 2 va (ef3 c4)) (16 3 va (ef3 c4)) (21 3 va (bf3 f4))
                    (22 1 va (bf3 af4)) (24 4 vt (bf3 f4)) (26 4 vt (bf3 f4))
                    (27 1 va (ef3 bf3)) (27 2 va (ef3 g3)) (27 3 va (ef3 g3))
                    (28 1 va (ef3 af3)) (30 5 va (f3 d4)) (31 1 va (f3 d4))
                    (31 2 va (g3 ef4)) (31 3 va (af3 d4)) (32 1 va (bf3 ef4))
                    (33 4 vt (bf3 f4)) (34 1 vt (bf3 g4)) (35 3 vt (bf3 d4))
                    (36 1 vt (bf3 ef4)) (36 2 va (ef3 g3)) (36 3 va (ef3 g3))
                    (37 1 va (ef3 af3)) (37 2 va (c3 af3)) (38 1 vt (c4 ef4))
                    (38 2 vt (bf3 ef4)) (39 4 vt (bf3 f4)) (39 5 vt (bf3 f4))
                    (39 6 vt (bf3 g4)) (42 9 va (ef3 cf4)) (43 1 va (df3 cf4))
                    (43 2 va (df3 cf4)) (43 3 va (df3 cf4)) (43 4 va (df3 cf4))
                    (43 5 va (df3 cf4)) (43 6 va (df3 cf4)) (43 7 va (df3 cf4))
                    (43 8 va (df3 cf4)) (43 9 va (df3 cf4)) (44 1 va (df3 bf3)) 
                    (44 2 va (df3 bf3)) (44 3 va (df3 bf3)) (44 4 va (df3 bf3))
                    (44 5 va (df3 bf3)) (44 6 va (df3 bf3)) (44 7 va (df3 bf3))
                    (44 8 va (df3 bf3)) (44 9 va (df3 bf3)) (45 1 vt (df4 ef4))
                    (45 2 vt (df4 ef4)) (45 3 vt (df4 ef4)) (45 4 vt (bf3 ef4))
                    (45 5 vt (bf3 ef4)) (45 6 vt (bf3 ef4)) (45 7 vt (cf4 ef4))
                    (45 8 vt (cf4 ef4)) (45 9 vt (cf4 ef4)) (45 1 va (ef3 bf3))
                    (45 2 va (ef3 bf3)) (45 3 va (ef3 bf3)) (46 1 vt (bf3 ef4))
                    (46 2 vt (bf3 ef4)) (46 3 vt (bf3 ef4)) (46 4 vt (bf3 ef4))
                    (46 5 vt (bf3 ef4)) (46 6 vt (bf3 ef4)) (46 7 vt (cf4 ef4))
                    (46 8 vt (cf4 ef4)) (46 9 vt (cf4 ef4)) (47 1 vt (cf4 ef4))
                    (47 2 vt (cf4 af4)) (48 3 va (df3 df4)) (49 2 va (ef3 g3))
                    (49 3 va (e3 g3)) (49 4 va (f3 af3)) (49 5 va (f3 d4))
                    (50 1 va (g3 ef4)) (56 2 vc (c2 bf2)) (56 3 vc (d2 bf2))
                    (57 2 va (ef3 bf3)) (57 3 va (f3 bf3)) (57 1 vc (ef2 bf2))
                    (57 2 vc (c2 bf2)) (57 3 vc (d2 bf2)) (58 1 vc (ef2 bf2))
                    (66 2 vt (bf3 g4)) (66 3 vt (bf3 g4)) (66 4 vt (bf3 g4))
                    (66 5 vt (bf3 g4)) (66 2 va (ef3 g3)) (66 3 va (ef3 g3))
                    (66 4 va (ef3 g3)) (66 5 va (ef3 g3)) (66 2 vc (ef2 bf2))
                    (66 3 vc (ef2 bf2)) (66 4 vc (ef2 bf2)) (66 5 vc (ef2 bf2)))
     do (change-pitch cavatina (first ds) (second ds) (third ds) (fourth ds)))
  ;;; add slurs/phrasing
  (loop for pl in '(vo vt va vc)
     for s in '(((1 1 1 2) (2 1 2 5) (3 1 3 2) (4 1 4 5) (5 1 6 3)
                 (7 1 7 6) (8 1 8 5) (10 1 10 2) (11 1 11 5) (12 1 12 2) 
                 (12 3 12 5) (13 1 13 2) (13 4 13 5) (14 1 14 2) (14 4 14 5)
                 (17 1 17 2) (18 1 18 2) (19 1 19 2) (20 1 20 4) (21 1 21 2) 
                 (24 1 24 2) (25 1 25 5) (26 1 26 4) (26 5 26 7) (27 3 27 5) 
                 (28 1 28 2) (28 3 28 4) (28 5 28 6) (29 1 29 3) (29 4 29 6) 
                 (30 1 30 2) (33 1 33 2) (34 2 34 5) (35 1 35 2) (35 4 35 6) 
                 (36 1 36 2) (36 3 36 5) (37 1 37 2) (37 3 37 4) (37 5 37 6) 
                 (38 1 38 3) (38 4 38 6) (39 1 39 3) (44 3 44 4) (44 5 44 6)
                 (45 3 45 5) (45 6 45 7) (46 1 46 2) (46 3 46 4) (46 5 46 6)
                 (46 7 46 8) (46 9 46 11) (47 1 47 3) (49 1 49 2) (50 1 50 5) 
                 (51 1 51 2) (52 1 52 5) (53 1 54 3) (55 1 55 6) (56 1 56 5) 
                 (58 2 58 3) (59 2 59 3) (60 1 60 6) (61 2 61 3) (62 2 62 3) 
                 (63 1 63 2) (63 3 63 5) (64 1 64 3) (65 1 65 3) (66 1 66 2))
                ((1 1 1 6) (3 2 3 6) (4 1 4 3) (5 1 5 2) (6 1 6 4) (7 1 7 4)
                 (8 2 8 3) (9 1 9 5) (10 1 10 6) (12 1 12 3) (14 1 14 4) 
                 (16 2 16 3) (17 1 17 6) (19 2 19 6) (21 3 21 5) (22 1 22 2) 
                 (22 4 22 5) (23 1 23 5) (24 1 24 3) (25 1 25 3) (26 1 26 3)
                 (28 1 28 2) (28 3 28 4) (28 5 28 6) (29 1 29 2) (29 3 29 5)
                 (30 2 30 5) (31 1 31 2) (32 1 32 4) (33 1 33 2) (34 1 35 3)
                 (37 2 37 3) (37 4 37 5) (38 4 38 5) (39 1 39 2) (40 1 40 3)
                 (40 4 40 6) (40 7 40 9) (48 1 48 2) (48 3 48 4) (49 1 49 6)
                 (51 2 51 6) (53 1 54 3) (55 1 55 4) (57 1 57 5) (59 1 59 6)
                 (60 2 60 5) (61 2 61 6) (62 2 62 6) (64 1 64 3) (64 4 64 6)
                 (65 1 65 2))
                ((1 1 1 3) (2 1 2 3) (3 1 3 5) (4 1 4 2) (5 1 6 1) (6 2 6 3)
                 (7 1 7 3) (7 4 7 5) (8 1 8 2) (9 2 9 3) (10 2 10 6) 
                 (11 1 11 4) (12 1 12 2) (14 1 14 2) (14 3 14 4) (17 1 17 2)
                 (18 1 18 6) (19 1 19 2) (21 3 21 5) (22 1 22 2) (22 3 22 4)
                 (23 1 23 3) (24 2 24 3) (26 1 26 3) (28 2 28 3) (28 4 28 5)
                 (29 1 29 4) (30 2 30 5) (31 2 31 3) (32 1 32 4) (33 2 33 3)
                 (35 2 35 3) (37 1 37 2) (37 3 37 4) (37 5 37 6) (38 1 38 4)
                 (39 1 39 2) (39 5 39 6) (40 1 40 3) (40 4 40 6) (40 7 40 9)
                 (47 4 47 5) (48 1 48 2) (48 3 48 4) (49 3 49 5) (50 1 50 3)
                 (51 1 51 4) (52 1 52 4) (53 1 53 2) (54 1 54 2) (54 3 54 4)
                 (55 1 55 4) (56 1 56 4) (57 2 57 3) (58 2 58 6) (59 1 59 6)
                 (60 2 60 4) (61 2 61 6) (62 4 62 5) (63 1 63 3) (64 1 64 3)
                 (64 4 64 6) (65 1 65 4))
                ((1 1 1 4) (2 1 2 4) (3 3 3 4) (4 1 4 4) (5 1 6 3) (7 1 7 4)
                 (8 2 8 3) (9 2 9 3) (10 1 10 6) (11 1 11 3) (12 1 12 3)
                 (14 1 14 3) (16 2 16 3) (20 2 20 6) (21 1 21 6) (22 3 22 4) 
                 (22 5 22 6) (23 1 23 3) (24 3 24 4) (25 1 25 3) (26 3 26 4)
                 (27 2 27 3) (30 1 30 3) (31 2 31 3) (32 1 32 4) (33 1 33 3)
                 (34 1 34 3) (35 1 35 3) (36 2 36 3) (37 1 37 3) (39 2 39 4)
                 (40 1 40 3) (40 4 40 6) (40 7 40 9) (48 2 48 3) (49 1 49 3)
                 (50 1 50 4) (51 3 51 4) (52 1 52 4) (53 1 54 3) (55 1 55 4)
                 (56 2 56 3) (57 2 57 3) (58 2 58 6) (59 1 59 4) (61 2 61 3)
                 (62 2 62 6) (63 1 63 4) (64 1 64 2) (64 3 65 4))) 
     do
       (loop for m in s
          do
            (add-mark-to-note cavatina (first m) (second m) pl 'beg-sl)
            (add-mark-to-note cavatina (third m) (fourth m) pl 'end-sl)))
  ;; add crescendos
  (loop for pl in '(vo vt va vc)
     for s in '(((1 3 1 4) (5 1 6 1) (8 1 8 2) (10 3 10 4) (13 4 13 6)
                 (15 1 15 2) (20 2 20 4) (24 3 25 1) (26 5 27 3) (28 1 29 1) 
                 (33 3 34 1) (35 4 36 3) (37 1 38 1) (45 6 45 8) (46 2 47 3) 
                 (49 3 49 4) (53 1 54 1) (56 1 56 3) (58 1 58 3) (59 1 59 3)
                 (61 1 61 2) (62 1 62 3) (65 2 65 4))
                ((1 1 1 5) (3 1 3 3) (5 1 6 1) (8 1 8 2) (10 1 10 2)
                 (13 2 13 3) (15 1 15 2) (16 1 16 2) (21 3 21 6) (22 3 22 5) 
                 (24 4 25 1) (26 4 27 2) (28 1 29 1) (31 3 32 1) (33 4 34 1) 
                 (35 3 36 2) (37 1 38 1) (39 4 39 6) (45 4 45 6) (46 1 47 3) 
                 (48 1 48 3) (49 1 49 3) (51 1 51 4) (53 1 54 1) (56 1 56 2) 
                 (57 1 57 3) (58 1 58 2) (59 1 59 3) (61 1 61 3) (62 2 62 4)
                 (65 3 65 5) (66 1 66 2))
                ((1 1 1 2) (3 1 3 3) (5 1 6 1) (8 1 8 2) (9 1 9 2) (10 1 10 2)
                 (13 2 13 3) (15 1 15 2) (16 1 16 2) (21 4 21 6) (22 3 22 6)
                 (24 4 25 1) (26 4 27 2) (28 1 29 1) (31 2 32 1) (33 4 34 1) 
                 (35 2 36 2) (37 1 38 1) (39 3 39 6) (45 4 45 6) (46 1 47 3) 
                 (48 1 48 3) (49 1 49 3) (51 1 51 2) (53 1 54 2) (56 1 56 3) 
                 (57 1 57 2) (58 1 58 4) (59 1 59 3) (61 1 61 3) (62 2 62 3) 
                 (65 3 65 6) (66 1 66 2))
                ((1 1 1 3) (5 1 6 1) (8 1 8 2) (9 1 9 2) (10 1 10 2)
                 (13 2 13 3) (15 1 15 2) (16 1 16 2) (20 2 21 6) (22 3 22 6)
                 (24 3 25 1) (26 3 27 2) (28 1 29 1) (31 2 32 1) (33 4 34 1)
                 (35 2 36 2) (37 1 38 1) (39 2 39 4) (45 4 45 6) (46 1 47 3)
                 (48 1 48 2) (49 1 49 2) (51 1 51 2) (53 1 54 1) (56 1 56 2)
                 (57 1 57 2) (58 1 58 4) (59 1 59 3) (61 1 61 2) (62 2 62 4)
                 (65 3 65 6) (66 1 66 2)))
     do
       (loop for m in s
          do
            (add-mark-to-event cavatina (first m) (second m) pl 'cresc-beg)
            (add-mark-to-event cavatina (third m) (fourth m) pl 'cresc-end)))
  ;; add diminuendos
  (loop for pl in '(vo vt va  vc)
     for s in '(((1 4 2 1) (6 2 6 3) (8 4 9 1) (10 4 11 1) (14 5 15 1)
                 (15 2 16 1) (21 1 21 3) (27 3 27 4) (29 1 29 4) (36 3 36 4)
                 (38 1 38 4) (47 4 48 1) (49 4 50 1) (54 2 54 3) (56 3 57 1)
                 (58 3 59 1) (59 4 60 1) (61 3 62 1) (62 4 64 1))
                ((1 5 1 6) (3 4 3 6) (6 3 6 4) (8 4 9 1) (10 4 10 6)
                 (14 3 15 1) (15 2 16 1) (16 3 17 1) (27 2 27 3)
                 (29 1 29 3) (36 2 36 3) (38 1 38 2) (47 4 48 1) (48 3 48 4)
                 (49 4 50 1) (51 4 51 6) (54 2 54 3) (56 3 57 1) (57 3 58 1)
                 (58 2 59 1) (59 4 60 1) (61 4 62 1) (62 4 64 1) (66 2 66 5))
                ((1 2 1 3) (3 4 3 5) (6 2 6 3) (8 2 9 1) (9 2 9 3) (10 4 10 6)
                 (14 3 15 1) (15 2 16 1) (16 3 17 1) (27 2 27 3) (29 1 29 3)
                 (33 1 33 3) (36 2 36 3) (38 1 38 3) (47 4 48 1) (48 3 48 4)
                 (49 3 50 1) (51 2 51 4) (54 3 54 4) (56 3 57 1) (57 3 58 1)
                 (58 5 59 1) (59 4 60 1) (61 4 62 1) (62 3 64 1) (66 2 66 5))
                ((1 3 1 4) (3 3 3 4) (6 2 6 3) (8 3 9 1) (9 2 9 3)
                 (10 4 10 6) (14 3 15 1) (15 2 16 1) (16 3 17 1) (27 2 27 4) 
                 (29 1 29 2) (33 1 33 3) (36 2 36 4) (38 1 38 2) (47 4 48 1) 
                 (48 2 48 3) (49 2 50 1) (51 2 51 4) (54 2 54 3) (56 3 57 1) 
                 (57 3 58 1) (58 5 59 1) (59 5 60 1) (61 3 62 1) (62 4 64 1) 
                 (66 2 66 5)))
     do
       (loop for m in s
          do
            (add-mark-to-event cavatina (first m) (second m) pl 'dim-beg)
            (add-mark-to-event cavatina (third m) (fourth m) pl 'dim-end)))
  ;; add other dynamics and performance indications
  (loop for pl in '(vo vt va vc)
     for b in '(((1 1 "sotto voce") (2 1 p) (7 1 p) (12 3 s) (12 4 s) (12 5 s) 
                 (15 1 p) (16 1 p) (21 3 p) (25 1 p) (27 3 f) (29 4 p) 
                 (34 1 p) (36 3 f) (37 1 p) (38 4 p) (41 2 pp) (42 1 "Beklemmt") 
                 (42 3 s) (45 9 p) (60 1 p) (64 1 p) (66 5 pause))
                ((1 1 "sotto voce") (2 1 p) (7 1 p) (15 1 p) (17 1 p) (22 1 a) 
                 (22 3 p) (23 1 "sotto voce") (25 1 p) (27 2 f) (29 3 p) 
                 (32 1 p) (34 1 p) (36 2 f) (37 1 p) (38 2 p) (40 1 pp) 
                 (40 1 s) (40 2 s) (40 3 s) (40 4 s) (40 5 s) (40 6 s) 
                 (40 7 s) (40 8 s) (40 9 s) (42 1 pp) (45 7 p) (49 1 p) 
                 (50 1 "sotto voce") (60 1 p) (64 1 p) (66 1 p) (66 5 pp) 
                 (66 5 pause))
                ((1 1 "sotto voce") (2 1 p) (7 1 p) (15 1 p) (17 1 p) (22 1 a)
                 (22 3 p) (23 1 "sotto voce") (25 1 p) (27 2 f) (29 3 p)
                 (32 1 p) (34 1 p) (36 2 f) (37 1 p) (38 3 p) (40 1 pp)
                 (40 1 s) (40 2 s) (40 3 s) (40 4 s) (40 5 s) (40 6 s) 
                 (40 7 s) (40 8 s) (40 9 s) (42 1 pp) (45 7 p) (49 1 p)
                 (50 1 "sotto voce") (60 1 p) (64 1 p) (66 1 p) (66 5 pp)
                 (66 5 pause))
                ((1 1 "sotto voce") (2 1 p) (7 1 p) (15 1 p) (17 1 p) 
                 (22 1 at) (22 3 p) (23 1 "sotto voce")
                 (25 1 p) (27 2 f) (29 2 p) (32 1 p) 
                 (34 1 p) (36 2 f) (37 1 p) (38 2 p) (40 1 s) (40 2 s) 
                 (40 3 s) (40 4 s) (40 5 s) (40 6 s) (40 7 s) (40 8 s) 
                 (40 9 s) (41 1 pp) (45 7 p) (49 1 p) (50 1 "sotto voce")
                 (60 1 p) (64 1 p) (66 1 p) (66 5 pp) (66 5 pause)))
     do 
       (loop for m in b
          do 
            (add-mark-to-event cavatina (first m) (second m) pl (third m))))
  (midi-play cavatina :midi-file "/tmp/cavatina.mid")
  ;; add double bar line for key change
  (change-bar-line-type cavatina 41 1)
  ;; key change to cf major
  (loop for pl in '(vo vt va vc)
     do (add-mark-before-note cavatina 42 1 pl '(key cf major)))
  ;; add double bar line for key change
  (change-bar-line-type cavatina 49 1)
  ;; key change back to ef major
  (loop for pl in '(vo vt va vc)
     do (add-mark-before-note cavatina 50 1 pl '(key ef major)))
  ;; add a few missing ties
  (loop for tl in '((8 1 vt) (8 3 vt) (11 3 vt) (4 2 va) (22 2 vc))
     do (tie cavatina (first tl)(second tl) (third tl)))
  ;; change the enharmonics of a couple of pitches; changing these appears to
  ;; automatically correct subsequent enharmonics issues
  (enharmonics cavatina 6 7 'vc :pitches '(bs2 gs2))
  ;; change the staff names and short staff names of the two violins
  (loop for pl in '(vo vt)
     for sn in '(("violin i" "vln i") ("violin ii" "vln ii"))
     with ens = (ensemble cavatina)
     do
       (setf (staff-name (get-data-data pl ens)) (first sn))
       (setf (staff-short-name (get-data-data pl ens)) (second sn)))
  (write-lp-data-for-all cavatina :respell-notes nil))